/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ExpireSessionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ExpireSessionRequest.Builder, ExpireSessionRequest> {
    private final String sessionId;

    private ExpireSessionRequest(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
    }

    /**
     * <p>
     * The ID of the streaming session.
     * </p>
     * 
     * @return The ID of the streaming session.
     */
    public String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpireSessionRequest)) {
            return false;
        }
        ExpireSessionRequest other = (ExpireSessionRequest) obj;
        return Objects.equals(sessionId(), other.sessionId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (sessionId() != null) {
            sb.append("SessionId: ").append(sessionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.of(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ExpireSessionRequest> {
        /**
         * <p>
         * The ID of the streaming session.
         * </p>
         * 
         * @param sessionId
         *        The ID of the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);
    }

    static final class BuilderImpl implements Builder {
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpireSessionRequest model) {
            sessionId(model.sessionId);
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public ExpireSessionRequest build() {
            return new ExpireSessionRequest(this);
        }
    }
}
