/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.SessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a streaming session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Session implements StructuredPojo, ToCopyableBuilder<Session.Builder, Session> {
    private final String id;

    private final String userId;

    private final String stackName;

    private final String fleetName;

    private final String state;

    private final String authenticationType;

    private Session(BuilderImpl builder) {
        this.id = builder.id;
        this.userId = builder.userId;
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.state = builder.state;
        this.authenticationType = builder.authenticationType;
    }

    /**
     * <p>
     * The ID of the streaming session.
     * </p>
     * 
     * @return The ID of the streaming session.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the user for whom the session was created.
     * </p>
     * 
     * @return The identifier of the user for whom the session was created.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the stack for the streaming session.
     * </p>
     * 
     * @return The name of the stack for the streaming session.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of the fleet for the streaming session.
     * </p>
     * 
     * @return The name of the fleet for the streaming session.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The current state of the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the streaming session.
     * @see SessionState
     */
    public SessionState state() {
        return SessionState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the streaming session.
     * @see SessionState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML federation
     * (<code>SAML</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeString}.
     * </p>
     * 
     * @return The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
     *         federation (<code>SAML</code>).
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML federation
     * (<code>SAML</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeString}.
     * </p>
     * 
     * @return The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
     *         federation (<code>SAML</code>).
     * @see AuthenticationType
     */
    public String authenticationTypeString() {
        return authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(userId(), other.userId())
                && Objects.equals(stackName(), other.stackName()) && Objects.equals(fleetName(), other.fleetName())
                && Objects.equals(stateString(), other.stateString())
                && Objects.equals(authenticationTypeString(), other.authenticationTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (userId() != null) {
            sb.append("UserId: ").append(userId()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (fleetName() != null) {
            sb.append("FleetName: ").append(fleetName()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (authenticationTypeString() != null) {
            sb.append("AuthenticationType: ").append(authenticationTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "UserId":
            return Optional.of(clazz.cast(userId()));
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "FleetName":
            return Optional.of(clazz.cast(fleetName()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "AuthenticationType":
            return Optional.of(clazz.cast(authenticationTypeString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Session> {
        /**
         * <p>
         * The ID of the streaming session.
         * </p>
         * 
         * @param id
         *        The ID of the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the user for whom the session was created.
         * </p>
         * 
         * @param userId
         *        The identifier of the user for whom the session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name of the stack for the streaming session.
         * </p>
         * 
         * @param stackName
         *        The name of the stack for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of the fleet for the streaming session.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The current state of the streaming session.
         * </p>
         * 
         * @param state
         *        The current state of the streaming session.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the streaming session.
         * </p>
         * 
         * @param state
         *        The current state of the streaming session.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(SessionState state);

        /**
         * <p>
         * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
         * federation (<code>SAML</code>).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
         *        federation (<code>SAML</code>).
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
         * federation (<code>SAML</code>).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
         *        federation (<code>SAML</code>).
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String userId;

        private String stackName;

        private String fleetName;

        private String state;

        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            id(model.id);
            userId(model.userId);
            stackName(model.stackName);
            fleetName(model.fleetName);
            state(model.state);
            authenticationType(model.authenticationType);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public Session build() {
            return new Session(this);
        }
    }
}
