/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.StorageConnectorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a storage connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StorageConnector implements StructuredPojo, ToCopyableBuilder<StorageConnector.Builder, StorageConnector> {
    private final String connectorType;

    private final String resourceIdentifier;

    private StorageConnector(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * <p>
     * The type of storage connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link StorageConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeString}.
     * </p>
     * 
     * @return The type of storage connector.
     * @see StorageConnectorType
     */
    public StorageConnectorType connectorType() {
        return StorageConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of storage connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link StorageConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeString}.
     * </p>
     * 
     * @return The type of storage connector.
     * @see StorageConnectorType
     */
    public String connectorTypeString() {
        return connectorType;
    }

    /**
     * <p>
     * The ARN of the storage connector.
     * </p>
     * 
     * @return The ARN of the storage connector.
     */
    public String resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConnector)) {
            return false;
        }
        StorageConnector other = (StorageConnector) obj;
        return Objects.equals(connectorTypeString(), other.connectorTypeString())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (connectorTypeString() != null) {
            sb.append("ConnectorType: ").append(connectorTypeString()).append(",");
        }
        if (resourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(resourceIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorType":
            return Optional.of(clazz.cast(connectorTypeString()));
        case "ResourceIdentifier":
            return Optional.of(clazz.cast(resourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageConnectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StorageConnector> {
        /**
         * <p>
         * The type of storage connector.
         * </p>
         * 
         * @param connectorType
         *        The type of storage connector.
         * @see StorageConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of storage connector.
         * </p>
         * 
         * @param connectorType
         *        The type of storage connector.
         * @see StorageConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorType
         */
        Builder connectorType(StorageConnectorType connectorType);

        /**
         * <p>
         * The ARN of the storage connector.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ARN of the storage connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String connectorType;

        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConnector model) {
            connectorType(model.connectorType);
            resourceIdentifier(model.resourceIdentifier);
        }

        public final String getConnectorType() {
            return connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(StorageConnectorType connectorType) {
            this.connectorType(connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public StorageConnector build() {
            return new StorageConnector(this);
        }
    }
}
