/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.appstream.model.ComputeCapacity;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.FleetType;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFleetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFleetRequest> {
    private final String name;
    private final String imageName;
    private final String instanceType;
    private final String fleetType;
    private final ComputeCapacity computeCapacity;
    private final VpcConfig vpcConfig;
    private final Integer maxUserDurationInSeconds;
    private final Integer disconnectTimeoutInSeconds;
    private final String description;
    private final String displayName;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;

    private CreateFleetRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.instanceType = builder.instanceType;
        this.fleetType = builder.fleetType;
        this.computeCapacity = builder.computeCapacity;
        this.vpcConfig = builder.vpcConfig;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
    }

    public String name() {
        return this.name;
    }

    public String imageName() {
        return this.imageName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public FleetType fleetType() {
        return FleetType.fromValue(this.fleetType);
    }

    public String fleetTypeString() {
        return this.fleetType;
    }

    public ComputeCapacity computeCapacity() {
        return this.computeCapacity;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Integer maxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Integer disconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.fleetTypeString(), other.fleetTypeString()) && Objects.equals(this.computeCapacity(), other.computeCapacity()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.maxUserDurationInSeconds(), other.maxUserDurationInSeconds()) && Objects.equals(this.disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.imageName() != null) {
            sb.append("ImageName: ").append(this.imageName()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.fleetTypeString() != null) {
            sb.append("FleetType: ").append(this.fleetTypeString()).append(",");
        }
        if (this.computeCapacity() != null) {
            sb.append("ComputeCapacity: ").append(this.computeCapacity()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.maxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(this.maxUserDurationInSeconds()).append(",");
        }
        if (this.disconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(this.disconnectTimeoutInSeconds()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(this.enableDefaultInternetAccess()).append(",");
        }
        if (this.domainJoinInfo() != null) {
            sb.append("DomainJoinInfo: ").append(this.domainJoinInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ImageName": {
                return Optional.of(clazz.cast(this.imageName()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "FleetType": {
                return Optional.of(clazz.cast(this.fleetTypeString()));
            }
            case "ComputeCapacity": {
                return Optional.of(clazz.cast(this.computeCapacity()));
            }
            case "VpcConfig": {
                return Optional.of(clazz.cast(this.vpcConfig()));
            }
            case "MaxUserDurationInSeconds": {
                return Optional.of(clazz.cast(this.maxUserDurationInSeconds()));
            }
            case "DisconnectTimeoutInSeconds": {
                return Optional.of(clazz.cast(this.disconnectTimeoutInSeconds()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.of(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.of(clazz.cast(this.domainJoinInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String imageName;
        private String instanceType;
        private String fleetType;
        private ComputeCapacity computeCapacity;
        private VpcConfig vpcConfig;
        private Integer maxUserDurationInSeconds;
        private Integer disconnectTimeoutInSeconds;
        private String description;
        private String displayName;
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            this.name(model.name);
            this.imageName(model.imageName);
            this.instanceType(model.instanceType);
            this.fleetType(model.fleetType);
            this.computeCapacity(model.computeCapacity);
            this.vpcConfig(model.vpcConfig);
            this.maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            this.disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            this.description(model.description);
            this.displayName(model.displayName);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getFleetType() {
            return this.fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType.toString());
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final ComputeCapacity.Builder getComputeCapacity() {
            return this.computeCapacity != null ? this.computeCapacity.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacity(ComputeCapacity computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        public final void setComputeCapacity(ComputeCapacity.BuilderImpl computeCapacity) {
            this.computeCapacity = computeCapacity != null ? computeCapacity.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFleetRequest> {
        public Builder name(String var1);

        public Builder imageName(String var1);

        public Builder instanceType(String var1);

        public Builder fleetType(String var1);

        public Builder fleetType(FleetType var1);

        public Builder computeCapacity(ComputeCapacity var1);

        default public Builder computeCapacity(Consumer<ComputeCapacity.Builder> computeCapacity) {
            return this.computeCapacity((ComputeCapacity)((ComputeCapacity.Builder)ComputeCapacity.builder().apply(computeCapacity)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().apply(vpcConfig)).build());
        }

        public Builder maxUserDurationInSeconds(Integer var1);

        public Builder disconnectTimeoutInSeconds(Integer var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().apply(domainJoinInfo)).build());
        }
    }
}

