/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appstream.model.ImageBuilder;
import software.amazon.awssdk.services.appstream.transform.DomainJoinInfoUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.ImageBuilderStateChangeReasonUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.ResourceErrorUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.VpcConfigUnmarshaller;

public class ImageBuilderUnmarshaller
implements Unmarshaller<ImageBuilder, JsonUnmarshallerContext> {
    private static final ImageBuilderUnmarshaller INSTANCE = new ImageBuilderUnmarshaller();

    public ImageBuilder unmarshall(JsonUnmarshallerContext context) throws Exception {
        ImageBuilder.Builder imageBuilderBuilder = ImageBuilder.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageArn", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.imageArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.displayName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VpcConfig", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.vpcConfig(VpcConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Platform", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.platform((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StateChangeReason", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.stateChangeReason(ImageBuilderStateChangeReasonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.createdTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("EnableDefaultInternetAccess", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.enableDefaultInternetAccess((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("DomainJoinInfo", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.domainJoinInfo(DomainJoinInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ImageBuilderErrors", targetDepth)) {
                    context.nextToken();
                    imageBuilderBuilder.imageBuilderErrors(new ListUnmarshaller((Unmarshaller)ResourceErrorUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ImageBuilder)imageBuilderBuilder.build();
    }

    public static ImageBuilderUnmarshaller getInstance() {
        return INSTANCE;
    }
}

