/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ComputeCapacityStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the capacity status for a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComputeCapacityStatus implements StructuredPojo,
        ToCopyableBuilder<ComputeCapacityStatus.Builder, ComputeCapacityStatus> {
    private final Integer desired;

    private final Integer running;

    private final Integer inUse;

    private final Integer available;

    private ComputeCapacityStatus(BuilderImpl builder) {
        this.desired = builder.desired;
        this.running = builder.running;
        this.inUse = builder.inUse;
        this.available = builder.available;
    }

    /**
     * <p>
     * The desired number of streaming instances.
     * </p>
     * 
     * @return The desired number of streaming instances.
     */
    public Integer desired() {
        return desired;
    }

    /**
     * <p>
     * The total number of simultaneous streaming instances that are running.
     * </p>
     * 
     * @return The total number of simultaneous streaming instances that are running.
     */
    public Integer running() {
        return running;
    }

    /**
     * <p>
     * The number of instances in use for streaming.
     * </p>
     * 
     * @return The number of instances in use for streaming.
     */
    public Integer inUse() {
        return inUse;
    }

    /**
     * <p>
     * The number of currently available instances that can be used to stream sessions.
     * </p>
     * 
     * @return The number of currently available instances that can be used to stream sessions.
     */
    public Integer available() {
        return available;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desired());
        hashCode = 31 * hashCode + Objects.hashCode(running());
        hashCode = 31 * hashCode + Objects.hashCode(inUse());
        hashCode = 31 * hashCode + Objects.hashCode(available());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeCapacityStatus)) {
            return false;
        }
        ComputeCapacityStatus other = (ComputeCapacityStatus) obj;
        return Objects.equals(desired(), other.desired()) && Objects.equals(running(), other.running())
                && Objects.equals(inUse(), other.inUse()) && Objects.equals(available(), other.available());
    }

    @Override
    public String toString() {
        return ToString.builder("ComputeCapacityStatus").add("Desired", desired()).add("Running", running())
                .add("InUse", inUse()).add("Available", available()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Desired":
            return Optional.of(clazz.cast(desired()));
        case "Running":
            return Optional.of(clazz.cast(running()));
        case "InUse":
            return Optional.of(clazz.cast(inUse()));
        case "Available":
            return Optional.of(clazz.cast(available()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeCapacityStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComputeCapacityStatus> {
        /**
         * <p>
         * The desired number of streaming instances.
         * </p>
         * 
         * @param desired
         *        The desired number of streaming instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desired(Integer desired);

        /**
         * <p>
         * The total number of simultaneous streaming instances that are running.
         * </p>
         * 
         * @param running
         *        The total number of simultaneous streaming instances that are running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder running(Integer running);

        /**
         * <p>
         * The number of instances in use for streaming.
         * </p>
         * 
         * @param inUse
         *        The number of instances in use for streaming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUse(Integer inUse);

        /**
         * <p>
         * The number of currently available instances that can be used to stream sessions.
         * </p>
         * 
         * @param available
         *        The number of currently available instances that can be used to stream sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder available(Integer available);
    }

    static final class BuilderImpl implements Builder {
        private Integer desired;

        private Integer running;

        private Integer inUse;

        private Integer available;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeCapacityStatus model) {
            desired(model.desired);
            running(model.running);
            inUse(model.inUse);
            available(model.available);
        }

        public final Integer getDesired() {
            return desired;
        }

        @Override
        public final Builder desired(Integer desired) {
            this.desired = desired;
            return this;
        }

        public final void setDesired(Integer desired) {
            this.desired = desired;
        }

        public final Integer getRunning() {
            return running;
        }

        @Override
        public final Builder running(Integer running) {
            this.running = running;
            return this;
        }

        public final void setRunning(Integer running) {
            this.running = running;
        }

        public final Integer getInUse() {
            return inUse;
        }

        @Override
        public final Builder inUse(Integer inUse) {
            this.inUse = inUse;
            return this;
        }

        public final void setInUse(Integer inUse) {
            this.inUse = inUse;
        }

        public final Integer getAvailable() {
            return available;
        }

        @Override
        public final Builder available(Integer available) {
            this.available = available;
            return this;
        }

        public final void setAvailable(Integer available) {
            this.available = available;
        }

        @Override
        public ComputeCapacityStatus build() {
            return new ComputeCapacityStatus(this);
        }
    }
}
