/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateImageBuilderStreamingURLResponse extends AppStreamResponse implements
        ToCopyableBuilder<CreateImageBuilderStreamingURLResponse.Builder, CreateImageBuilderStreamingURLResponse> {
    private final String streamingURL;

    private final Instant expires;

    private CreateImageBuilderStreamingURLResponse(BuilderImpl builder) {
        super(builder);
        this.streamingURL = builder.streamingURL;
        this.expires = builder.expires;
    }

    /**
     * Returns the value of the StreamingURL property for this object.
     * 
     * @return The value of the StreamingURL property for this object.
     */
    public String streamingURL() {
        return streamingURL;
    }

    /**
     * Returns the value of the Expires property for this object.
     * 
     * @return The value of the Expires property for this object.
     */
    public Instant expires() {
        return expires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingURL());
        hashCode = 31 * hashCode + Objects.hashCode(expires());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageBuilderStreamingURLResponse)) {
            return false;
        }
        CreateImageBuilderStreamingURLResponse other = (CreateImageBuilderStreamingURLResponse) obj;
        return Objects.equals(streamingURL(), other.streamingURL()) && Objects.equals(expires(), other.expires());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateImageBuilderStreamingURLResponse").add("StreamingURL", streamingURL())
                .add("Expires", expires()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingURL":
            return Optional.of(clazz.cast(streamingURL()));
        case "Expires":
            return Optional.of(clazz.cast(expires()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, CreateImageBuilderStreamingURLResponse> {
        /**
         * Sets the value of the StreamingURL property for this object.
         *
         * @param streamingURL
         *        The new value for the StreamingURL property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingURL(String streamingURL);

        /**
         * Sets the value of the Expires property for this object.
         *
         * @param expires
         *        The new value for the Expires property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expires(Instant expires);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private String streamingURL;

        private Instant expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageBuilderStreamingURLResponse model) {
            streamingURL(model.streamingURL);
            expires(model.expires);
        }

        public final String getStreamingURL() {
            return streamingURL;
        }

        @Override
        public final Builder streamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
            return this;
        }

        public final void setStreamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
        }

        public final Instant getExpires() {
            return expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        @Override
        public CreateImageBuilderStreamingURLResponse build() {
            return new CreateImageBuilderStreamingURLResponse(this);
        }
    }
}
