/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDirectoryConfigRequest extends AppStreamRequest implements
        ToCopyableBuilder<DeleteDirectoryConfigRequest.Builder, DeleteDirectoryConfigRequest> {
    private final String directoryName;

    private DeleteDirectoryConfigRequest(BuilderImpl builder) {
        super(builder);
        this.directoryName = builder.directoryName;
    }

    /**
     * <p>
     * The name of the directory configuration.
     * </p>
     * 
     * @return The name of the directory configuration.
     */
    public String directoryName() {
        return directoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDirectoryConfigRequest)) {
            return false;
        }
        DeleteDirectoryConfigRequest other = (DeleteDirectoryConfigRequest) obj;
        return Objects.equals(directoryName(), other.directoryName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteDirectoryConfigRequest").add("DirectoryName", directoryName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryName":
            return Optional.of(clazz.cast(directoryName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, DeleteDirectoryConfigRequest> {
        /**
         * <p>
         * The name of the directory configuration.
         * </p>
         * 
         * @param directoryName
         *        The name of the directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String directoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDirectoryConfigRequest model) {
            directoryName(model.directoryName);
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteDirectoryConfigRequest build() {
            return new DeleteDirectoryConfigRequest(this);
        }
    }
}
