/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDirectoryConfigsResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeDirectoryConfigsResponse.Builder, DescribeDirectoryConfigsResponse> {
    private final List<DirectoryConfig> directoryConfigs;

    private final String nextToken;

    private DescribeDirectoryConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryConfigs = builder.directoryConfigs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the directory configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the directory configurations.
     */
    public List<DirectoryConfig> directoryConfigs() {
        return directoryConfigs;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoryConfigsResponse)) {
            return false;
        }
        DescribeDirectoryConfigsResponse other = (DescribeDirectoryConfigsResponse) obj;
        return Objects.equals(directoryConfigs(), other.directoryConfigs()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDirectoryConfigsResponse").add("DirectoryConfigs", directoryConfigs())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryConfigs":
            return Optional.of(clazz.cast(directoryConfigs()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, DescribeDirectoryConfigsResponse> {
        /**
         * <p>
         * Information about the directory configurations.
         * </p>
         * 
         * @param directoryConfigs
         *        Information about the directory configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryConfigs(Collection<DirectoryConfig> directoryConfigs);

        /**
         * <p>
         * Information about the directory configurations.
         * </p>
         * 
         * @param directoryConfigs
         *        Information about the directory configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryConfigs(DirectoryConfig... directoryConfigs);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<DirectoryConfig> directoryConfigs;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoryConfigsResponse model) {
            directoryConfigs(model.directoryConfigs);
            nextToken(model.nextToken);
        }

        public final Collection<DirectoryConfig.Builder> getDirectoryConfigs() {
            return directoryConfigs != null ? directoryConfigs.stream().map(DirectoryConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directoryConfigs(Collection<DirectoryConfig> directoryConfigs) {
            this.directoryConfigs = DirectoryConfigListCopier.copy(directoryConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryConfigs(DirectoryConfig... directoryConfigs) {
            directoryConfigs(Arrays.asList(directoryConfigs));
            return this;
        }

        public final void setDirectoryConfigs(Collection<DirectoryConfig.BuilderImpl> directoryConfigs) {
            this.directoryConfigs = DirectoryConfigListCopier.copyFromBuilder(directoryConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectoryConfigsResponse build() {
            return new DescribeDirectoryConfigsResponse(this);
        }
    }
}
