/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ImageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Image implements StructuredPojo, ToCopyableBuilder<Image.Builder, Image> {
    private final String name;

    private final String arn;

    private final String baseImageArn;

    private final String displayName;

    private final String state;

    private final String visibility;

    private final Boolean imageBuilderSupported;

    private final String platform;

    private final String description;

    private final ImageStateChangeReason stateChangeReason;

    private final List<Application> applications;

    private final Instant createdTime;

    private final Instant publicBaseImageReleasedDate;

    private Image(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.baseImageArn = builder.baseImageArn;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.imageBuilderSupported = builder.imageBuilderSupported;
        this.platform = builder.platform;
        this.description = builder.description;
        this.stateChangeReason = builder.stateChangeReason;
        this.applications = builder.applications;
        this.createdTime = builder.createdTime;
        this.publicBaseImageReleasedDate = builder.publicBaseImageReleasedDate;
    }

    /**
     * <p>
     * The name of the image.
     * </p>
     * 
     * @return The name of the image.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the image.
     * </p>
     * 
     * @return The ARN of the image.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the image from which this image was created.
     * </p>
     * 
     * @return The ARN of the image from which this image was created.
     */
    public String baseImageArn() {
        return baseImageArn;
    }

    /**
     * <p>
     * The image name displayed to end users.
     * </p>
     * 
     * @return The image name displayed to end users.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
     * <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
     *         <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
     * @see ImageState
     */
    public ImageState state() {
        return ImageState.fromValue(state);
    }

    /**
     * <p>
     * The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
     * <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
     *         <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
     * @see ImageState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * Indicates whether the image is public or private.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link VisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityString}.
     * </p>
     * 
     * @return Indicates whether the image is public or private.
     * @see VisibilityType
     */
    public VisibilityType visibility() {
        return VisibilityType.fromValue(visibility);
    }

    /**
     * <p>
     * Indicates whether the image is public or private.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link VisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityString}.
     * </p>
     * 
     * @return Indicates whether the image is public or private.
     * @see VisibilityType
     */
    public String visibilityString() {
        return visibility;
    }

    /**
     * <p>
     * Indicates whether an image builder can be launched from this image.
     * </p>
     * 
     * @return Indicates whether an image builder can be launched from this image.
     */
    public Boolean imageBuilderSupported() {
        return imageBuilderSupported;
    }

    /**
     * <p>
     * The operating system platform of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The operating system platform of the image.
     * @see PlatformType
     */
    public PlatformType platform() {
        return PlatformType.fromValue(platform);
    }

    /**
     * <p>
     * The operating system platform of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The operating system platform of the image.
     * @see PlatformType
     */
    public String platformString() {
        return platform;
    }

    /**
     * <p>
     * The description displayed to end users.
     * </p>
     * 
     * @return The description displayed to end users.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The reason why the last state change occurred.
     * </p>
     * 
     * @return The reason why the last state change occurred.
     */
    public ImageStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * The applications associated with the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The applications associated with the image.
     */
    public List<Application> applications() {
        return applications;
    }

    /**
     * <p>
     * The time the image was created.
     * </p>
     * 
     * @return The time the image was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The release date of the public base image. For private images, this date is the release date of the base image
     * from which the image was created.
     * </p>
     * 
     * @return The release date of the public base image. For private images, this date is the release date of the base
     *         image from which the image was created.
     */
    public Instant publicBaseImageReleasedDate() {
        return publicBaseImageReleasedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(baseImageArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityString());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuilderSupported());
        hashCode = 31 * hashCode + Objects.hashCode(platformString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(applications());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(publicBaseImageReleasedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(baseImageArn(), other.baseImageArn()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(stateString(), other.stateString())
                && Objects.equals(visibilityString(), other.visibilityString())
                && Objects.equals(imageBuilderSupported(), other.imageBuilderSupported())
                && Objects.equals(platformString(), other.platformString()) && Objects.equals(description(), other.description())
                && Objects.equals(stateChangeReason(), other.stateChangeReason())
                && Objects.equals(applications(), other.applications()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(publicBaseImageReleasedDate(), other.publicBaseImageReleasedDate());
    }

    @Override
    public String toString() {
        return ToString.builder("Image").add("Name", name()).add("Arn", arn()).add("BaseImageArn", baseImageArn())
                .add("DisplayName", displayName()).add("State", stateString()).add("Visibility", visibilityString())
                .add("ImageBuilderSupported", imageBuilderSupported()).add("Platform", platformString())
                .add("Description", description()).add("StateChangeReason", stateChangeReason())
                .add("Applications", applications()).add("CreatedTime", createdTime())
                .add("PublicBaseImageReleasedDate", publicBaseImageReleasedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "BaseImageArn":
            return Optional.of(clazz.cast(baseImageArn()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "Visibility":
            return Optional.of(clazz.cast(visibilityString()));
        case "ImageBuilderSupported":
            return Optional.of(clazz.cast(imageBuilderSupported()));
        case "Platform":
            return Optional.of(clazz.cast(platformString()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "StateChangeReason":
            return Optional.of(clazz.cast(stateChangeReason()));
        case "Applications":
            return Optional.of(clazz.cast(applications()));
        case "CreatedTime":
            return Optional.of(clazz.cast(createdTime()));
        case "PublicBaseImageReleasedDate":
            return Optional.of(clazz.cast(publicBaseImageReleasedDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * The name of the image.
         * </p>
         * 
         * @param name
         *        The name of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the image.
         * </p>
         * 
         * @param arn
         *        The ARN of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the image from which this image was created.
         * </p>
         * 
         * @param baseImageArn
         *        The ARN of the image from which this image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseImageArn(String baseImageArn);

        /**
         * <p>
         * The image name displayed to end users.
         * </p>
         * 
         * @param displayName
         *        The image name displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
         * <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
         * </p>
         * 
         * @param state
         *        The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
         *        <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
         * <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
         * </p>
         * 
         * @param state
         *        The image starts in the <code>PENDING</code> state. If image creation succeeds, the state is
         *        <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(ImageState state);

        /**
         * <p>
         * Indicates whether the image is public or private.
         * </p>
         * 
         * @param visibility
         *        Indicates whether the image is public or private.
         * @see VisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityType
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Indicates whether the image is public or private.
         * </p>
         * 
         * @param visibility
         *        Indicates whether the image is public or private.
         * @see VisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityType
         */
        Builder visibility(VisibilityType visibility);

        /**
         * <p>
         * Indicates whether an image builder can be launched from this image.
         * </p>
         * 
         * @param imageBuilderSupported
         *        Indicates whether an image builder can be launched from this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilderSupported(Boolean imageBuilderSupported);

        /**
         * <p>
         * The operating system platform of the image.
         * </p>
         * 
         * @param platform
         *        The operating system platform of the image.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(String platform);

        /**
         * <p>
         * The operating system platform of the image.
         * </p>
         * 
         * @param platform
         *        The operating system platform of the image.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(PlatformType platform);

        /**
         * <p>
         * The description displayed to end users.
         * </p>
         * 
         * @param description
         *        The description displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reason why the last state change occurred.
         * </p>
         * 
         * @param stateChangeReason
         *        The reason why the last state change occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(ImageStateChangeReason stateChangeReason);

        /**
         * <p>
         * The reason why the last state change occurred.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageStateChangeReason.Builder} avoiding the
         * need to create one manually via {@link ImageStateChangeReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageStateChangeReason.Builder#build()} is called immediately and
         * its result is passed to {@link #stateChangeReason(ImageStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link ImageStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(ImageStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<ImageStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(ImageStateChangeReason.builder().apply(stateChangeReason).build());
        }

        /**
         * <p>
         * The applications associated with the image.
         * </p>
         * 
         * @param applications
         *        The applications associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<Application> applications);

        /**
         * <p>
         * The applications associated with the image.
         * </p>
         * 
         * @param applications
         *        The applications associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Application... applications);

        /**
         * <p>
         * The time the image was created.
         * </p>
         * 
         * @param createdTime
         *        The time the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The release date of the public base image. For private images, this date is the release date of the base
         * image from which the image was created.
         * </p>
         * 
         * @param publicBaseImageReleasedDate
         *        The release date of the public base image. For private images, this date is the release date of the
         *        base image from which the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String baseImageArn;

        private String displayName;

        private String state;

        private String visibility;

        private Boolean imageBuilderSupported;

        private String platform;

        private String description;

        private ImageStateChangeReason stateChangeReason;

        private List<Application> applications;

        private Instant createdTime;

        private Instant publicBaseImageReleasedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            name(model.name);
            arn(model.arn);
            baseImageArn(model.baseImageArn);
            displayName(model.displayName);
            state(model.state);
            visibility(model.visibility);
            imageBuilderSupported(model.imageBuilderSupported);
            platform(model.platform);
            description(model.description);
            stateChangeReason(model.stateChangeReason);
            applications(model.applications);
            createdTime(model.createdTime);
            publicBaseImageReleasedDate(model.publicBaseImageReleasedDate);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBaseImageArn() {
            return baseImageArn;
        }

        @Override
        public final Builder baseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
            return this;
        }

        public final void setBaseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVisibility() {
            return visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(VisibilityType visibility) {
            this.visibility(visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final Boolean getImageBuilderSupported() {
            return imageBuilderSupported;
        }

        @Override
        public final Builder imageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
            return this;
        }

        public final void setImageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ImageStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final Collection<Application.Builder> getApplications() {
            return applications != null ? applications.stream().map(Application::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getPublicBaseImageReleasedDate() {
            return publicBaseImageReleasedDate;
        }

        @Override
        public final Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
            return this;
        }

        public final void setPublicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
        }

        @Override
        public Image build() {
            return new Image(this);
        }
    }
}
