/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ImageBuilderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ImageBuilder implements StructuredPojo, ToCopyableBuilder<ImageBuilder.Builder, ImageBuilder> {
    private final String name;

    private final String arn;

    private final String imageArn;

    private final String description;

    private final String displayName;

    private final VpcConfig vpcConfig;

    private final String instanceType;

    private final String platform;

    private final String state;

    private final ImageBuilderStateChangeReason stateChangeReason;

    private final Instant createdTime;

    private final Boolean enableDefaultInternetAccess;

    private final DomainJoinInfo domainJoinInfo;

    private final List<ResourceError> imageBuilderErrors;

    private ImageBuilder(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.imageArn = builder.imageArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.vpcConfig = builder.vpcConfig;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.createdTime = builder.createdTime;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.imageBuilderErrors = builder.imageBuilderErrors;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public String name() {
        return name;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns the value of the ImageArn property for this object.
     * 
     * @return The value of the ImageArn property for this object.
     */
    public String imageArn() {
        return imageArn;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the DisplayName property for this object.
     * 
     * @return The value of the DisplayName property for this object.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * Returns the value of the InstanceType property for this object.
     * 
     * @return The value of the InstanceType property for this object.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * Returns the value of the Platform property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The value of the Platform property for this object.
     * @see PlatformType
     */
    public PlatformType platform() {
        return PlatformType.fromValue(platform);
    }

    /**
     * Returns the value of the Platform property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The value of the Platform property for this object.
     * @see PlatformType
     */
    public String platformString() {
        return platform;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageBuilderState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see ImageBuilderState
     */
    public ImageBuilderState state() {
        return ImageBuilderState.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageBuilderState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see ImageBuilderState
     */
    public String stateString() {
        return state;
    }

    /**
     * Returns the value of the StateChangeReason property for this object.
     * 
     * @return The value of the StateChangeReason property for this object.
     */
    public ImageBuilderStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * Returns the value of the CreatedTime property for this object.
     * 
     * @return The value of the CreatedTime property for this object.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * Returns the value of the EnableDefaultInternetAccess property for this object.
     * 
     * @return The value of the EnableDefaultInternetAccess property for this object.
     */
    public Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * Returns the value of the DomainJoinInfo property for this object.
     * 
     * @return The value of the DomainJoinInfo property for this object.
     */
    public DomainJoinInfo domainJoinInfo() {
        return domainJoinInfo;
    }

    /**
     * Returns the value of the ImageBuilderErrors property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ImageBuilderErrors property for this object.
     */
    public List<ResourceError> imageBuilderErrors() {
        return imageBuilderErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(platformString());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuilderErrors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBuilder)) {
            return false;
        }
        ImageBuilder other = (ImageBuilder) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(platformString(), other.platformString()) && Objects.equals(stateString(), other.stateString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(domainJoinInfo(), other.domainJoinInfo())
                && Objects.equals(imageBuilderErrors(), other.imageBuilderErrors());
    }

    @Override
    public String toString() {
        return ToString.builder("ImageBuilder").add("Name", name()).add("Arn", arn()).add("ImageArn", imageArn())
                .add("Description", description()).add("DisplayName", displayName()).add("VpcConfig", vpcConfig())
                .add("InstanceType", instanceType()).add("Platform", platformString()).add("State", stateString())
                .add("StateChangeReason", stateChangeReason()).add("CreatedTime", createdTime())
                .add("EnableDefaultInternetAccess", enableDefaultInternetAccess()).add("DomainJoinInfo", domainJoinInfo())
                .add("ImageBuilderErrors", imageBuilderErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "ImageArn":
            return Optional.of(clazz.cast(imageArn()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        case "VpcConfig":
            return Optional.of(clazz.cast(vpcConfig()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "Platform":
            return Optional.of(clazz.cast(platformString()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "StateChangeReason":
            return Optional.of(clazz.cast(stateChangeReason()));
        case "CreatedTime":
            return Optional.of(clazz.cast(createdTime()));
        case "EnableDefaultInternetAccess":
            return Optional.of(clazz.cast(enableDefaultInternetAccess()));
        case "DomainJoinInfo":
            return Optional.of(clazz.cast(domainJoinInfo()));
        case "ImageBuilderErrors":
            return Optional.of(clazz.cast(imageBuilderErrors()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageBuilderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ImageBuilder> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the ImageArn property for this object.
         *
         * @param imageArn
         *        The new value for the ImageArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the DisplayName property for this object.
         *
         * @param displayName
         *        The new value for the DisplayName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().apply(vpcConfig).build());
        }

        /**
         * Sets the value of the InstanceType property for this object.
         *
         * @param instanceType
         *        The new value for the InstanceType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * Sets the value of the Platform property for this object.
         *
         * @param platform
         *        The new value for the Platform property for this object.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(String platform);

        /**
         * Sets the value of the Platform property for this object.
         *
         * @param platform
         *        The new value for the Platform property for this object.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(PlatformType platform);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see ImageBuilderState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageBuilderState
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see ImageBuilderState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageBuilderState
         */
        Builder state(ImageBuilderState state);

        /**
         * Sets the value of the StateChangeReason property for this object.
         *
         * @param stateChangeReason
         *        The new value for the StateChangeReason property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(ImageBuilderStateChangeReason stateChangeReason);

        /**
         * Sets the value of the StateChangeReason property for this object.
         *
         * This is a convenience that creates an instance of the {@link ImageBuilderStateChangeReason.Builder} avoiding
         * the need to create one manually via {@link ImageBuilderStateChangeReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageBuilderStateChangeReason.Builder#build()} is called
         * immediately and its result is passed to {@link #stateChangeReason(ImageBuilderStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link ImageBuilderStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(ImageBuilderStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<ImageBuilderStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(ImageBuilderStateChangeReason.builder().apply(stateChangeReason).build());
        }

        /**
         * Sets the value of the CreatedTime property for this object.
         *
         * @param createdTime
         *        The new value for the CreatedTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * Sets the value of the EnableDefaultInternetAccess property for this object.
         *
         * @param enableDefaultInternetAccess
         *        The new value for the EnableDefaultInternetAccess property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * Sets the value of the DomainJoinInfo property for this object.
         *
         * @param domainJoinInfo
         *        The new value for the DomainJoinInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainJoinInfo(DomainJoinInfo domainJoinInfo);

        /**
         * Sets the value of the DomainJoinInfo property for this object.
         *
         * This is a convenience that creates an instance of the {@link DomainJoinInfo.Builder} avoiding the need to
         * create one manually via {@link DomainJoinInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainJoinInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainJoinInfo(DomainJoinInfo)}.
         * 
         * @param domainJoinInfo
         *        a consumer that will call methods on {@link DomainJoinInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainJoinInfo(DomainJoinInfo)
         */
        default Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return domainJoinInfo(DomainJoinInfo.builder().apply(domainJoinInfo).build());
        }

        /**
         * Sets the value of the ImageBuilderErrors property for this object.
         *
         * @param imageBuilderErrors
         *        The new value for the ImageBuilderErrors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilderErrors(Collection<ResourceError> imageBuilderErrors);

        /**
         * Sets the value of the ImageBuilderErrors property for this object.
         *
         * @param imageBuilderErrors
         *        The new value for the ImageBuilderErrors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilderErrors(ResourceError... imageBuilderErrors);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String imageArn;

        private String description;

        private String displayName;

        private VpcConfig vpcConfig;

        private String instanceType;

        private String platform;

        private String state;

        private ImageBuilderStateChangeReason stateChangeReason;

        private Instant createdTime;

        private Boolean enableDefaultInternetAccess;

        private DomainJoinInfo domainJoinInfo;

        private List<ResourceError> imageBuilderErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageBuilder model) {
            name(model.name);
            arn(model.arn);
            imageArn(model.imageArn);
            description(model.description);
            displayName(model.displayName);
            vpcConfig(model.vpcConfig);
            instanceType(model.instanceType);
            platform(model.platform);
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            createdTime(model.createdTime);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            domainJoinInfo(model.domainJoinInfo);
            imageBuilderErrors(model.imageBuilderErrors);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getImageArn() {
            return imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageBuilderState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ImageBuilderStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(ImageBuilderStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageBuilderStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return domainJoinInfo != null ? domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final Collection<ResourceError.Builder> getImageBuilderErrors() {
            return imageBuilderErrors != null ? imageBuilderErrors.stream().map(ResourceError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageBuilderErrors(Collection<ResourceError> imageBuilderErrors) {
            this.imageBuilderErrors = ResourceErrorsCopier.copy(imageBuilderErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageBuilderErrors(ResourceError... imageBuilderErrors) {
            imageBuilderErrors(Arrays.asList(imageBuilderErrors));
            return this;
        }

        public final void setImageBuilderErrors(Collection<ResourceError.BuilderImpl> imageBuilderErrors) {
            this.imageBuilderErrors = ResourceErrorsCopier.copyFromBuilder(imageBuilderErrors);
        }

        @Override
        public ImageBuilder build() {
            return new ImageBuilder(this);
        }
    }
}
