/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListAssociatedFleetsResponse extends AppStreamResponse implements
        ToCopyableBuilder<ListAssociatedFleetsResponse.Builder, ListAssociatedFleetsResponse> {
    private final List<String> names;

    private final String nextToken;

    private ListAssociatedFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.names = builder.names;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of the fleets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the fleets.
     */
    public List<String> names() {
        return names;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(names());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedFleetsResponse)) {
            return false;
        }
        ListAssociatedFleetsResponse other = (ListAssociatedFleetsResponse) obj;
        return Objects.equals(names(), other.names()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAssociatedFleetsResponse").add("Names", names()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Names":
            return Optional.of(clazz.cast(names()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, ListAssociatedFleetsResponse> {
        /**
         * <p>
         * The names of the fleets.
         * </p>
         * 
         * @param names
         *        The names of the fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * The names of the fleets.
         * </p>
         * 
         * @param names
         *        The names of the fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<String> names;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedFleetsResponse model) {
            names(model.names);
            nextToken(model.nextToken);
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = StringListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = StringListCopier.copy(names);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociatedFleetsResponse build() {
            return new ListAssociatedFleetsResponse(this);
        }
    }
}
