/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.StackMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Stack implements StructuredPojo, ToCopyableBuilder<Stack.Builder, Stack> {
    private final String arn;

    private final String name;

    private final String description;

    private final String displayName;

    private final Instant createdTime;

    private final List<StorageConnector> storageConnectors;

    private final List<StackError> stackErrors;

    private Stack(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.storageConnectors = builder.storageConnectors;
        this.stackErrors = builder.stackErrors;
    }

    /**
     * <p>
     * The ARN of the stack.
     * </p>
     * 
     * @return The ARN of the stack.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description displayed to end users.
     * </p>
     * 
     * @return The description displayed to end users.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The stack name displayed to end users.
     * </p>
     * 
     * @return The stack name displayed to end users.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The time the stack was created.
     * </p>
     * 
     * @return The time the stack was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The storage connectors to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The storage connectors to enable.
     */
    public List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * The errors for the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The errors for the stack.
     */
    public List<StackError> stackErrors() {
        return stackErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(storageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(stackErrors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(storageConnectors(), other.storageConnectors())
                && Objects.equals(stackErrors(), other.stackErrors());
    }

    @Override
    public String toString() {
        return ToString.builder("Stack").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("DisplayName", displayName()).add("CreatedTime", createdTime())
                .add("StorageConnectors", storageConnectors()).add("StackErrors", stackErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        case "CreatedTime":
            return Optional.of(clazz.cast(createdTime()));
        case "StorageConnectors":
            return Optional.of(clazz.cast(storageConnectors()));
        case "StackErrors":
            return Optional.of(clazz.cast(stackErrors()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Stack> {
        /**
         * <p>
         * The ARN of the stack.
         * </p>
         * 
         * @param arn
         *        The ARN of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param name
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description displayed to end users.
         * </p>
         * 
         * @param description
         *        The description displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stack name displayed to end users.
         * </p>
         * 
         * @param displayName
         *        The stack name displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The time the stack was created.
         * </p>
         * 
         * @param createdTime
         *        The time the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * The errors for the stack.
         * </p>
         * 
         * @param stackErrors
         *        The errors for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackErrors(Collection<StackError> stackErrors);

        /**
         * <p>
         * The errors for the stack.
         * </p>
         * 
         * @param stackErrors
         *        The errors for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackErrors(StackError... stackErrors);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String displayName;

        private Instant createdTime;

        private List<StorageConnector> storageConnectors;

        private List<StackError> stackErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            displayName(model.displayName);
            createdTime(model.createdTime);
            storageConnectors(model.storageConnectors);
            stackErrors(model.stackErrors);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return storageConnectors != null ? storageConnectors.stream().map(StorageConnector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final Collection<StackError.Builder> getStackErrors() {
            return stackErrors != null ? stackErrors.stream().map(StackError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackErrors(Collection<StackError> stackErrors) {
            this.stackErrors = StackErrorsCopier.copy(stackErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackErrors(StackError... stackErrors) {
            stackErrors(Arrays.asList(stackErrors));
            return this;
        }

        public final void setStackErrors(Collection<StackError.BuilderImpl> stackErrors) {
            this.stackErrors = StackErrorsCopier.copyFromBuilder(stackErrors);
        }

        @Override
        public Stack build() {
            return new Stack(this);
        }
    }
}
