/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StartImageBuilderResponse extends AppStreamResponse implements
        ToCopyableBuilder<StartImageBuilderResponse.Builder, StartImageBuilderResponse> {
    private final ImageBuilder imageBuilder;

    private StartImageBuilderResponse(BuilderImpl builder) {
        super(builder);
        this.imageBuilder = builder.imageBuilder;
    }

    /**
     * Returns the value of the ImageBuilder property for this object.
     * 
     * @return The value of the ImageBuilder property for this object.
     */
    public ImageBuilder imageBuilder() {
        return imageBuilder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageBuilder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImageBuilderResponse)) {
            return false;
        }
        StartImageBuilderResponse other = (StartImageBuilderResponse) obj;
        return Objects.equals(imageBuilder(), other.imageBuilder());
    }

    @Override
    public String toString() {
        return ToString.builder("StartImageBuilderResponse").add("ImageBuilder", imageBuilder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageBuilder":
            return Optional.of(clazz.cast(imageBuilder()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, StartImageBuilderResponse> {
        /**
         * Sets the value of the ImageBuilder property for this object.
         *
         * @param imageBuilder
         *        The new value for the ImageBuilder property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilder(ImageBuilder imageBuilder);

        /**
         * Sets the value of the ImageBuilder property for this object.
         *
         * This is a convenience that creates an instance of the {@link ImageBuilder.Builder} avoiding the need to
         * create one manually via {@link ImageBuilder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageBuilder.Builder#build()} is called immediately and its
         * result is passed to {@link #imageBuilder(ImageBuilder)}.
         * 
         * @param imageBuilder
         *        a consumer that will call methods on {@link ImageBuilder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageBuilder(ImageBuilder)
         */
        default Builder imageBuilder(Consumer<ImageBuilder.Builder> imageBuilder) {
            return imageBuilder(ImageBuilder.builder().apply(imageBuilder).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private ImageBuilder imageBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImageBuilderResponse model) {
            imageBuilder(model.imageBuilder);
        }

        public final ImageBuilder.Builder getImageBuilder() {
            return imageBuilder != null ? imageBuilder.toBuilder() : null;
        }

        @Override
        public final Builder imageBuilder(ImageBuilder imageBuilder) {
            this.imageBuilder = imageBuilder;
            return this;
        }

        public final void setImageBuilder(ImageBuilder.BuilderImpl imageBuilder) {
            this.imageBuilder = imageBuilder != null ? imageBuilder.build() : null;
        }

        @Override
        public StartImageBuilderResponse build() {
            return new StartImageBuilderResponse(this);
        }
    }
}
