/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateFleetResponse extends AppStreamResponse implements
        ToCopyableBuilder<UpdateFleetResponse.Builder, UpdateFleetResponse> {
    private final Fleet fleet;

    private UpdateFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleet = builder.fleet;
    }

    /**
     * <p>
     * Information about the fleet.
     * </p>
     * 
     * @return Information about the fleet.
     */
    public Fleet fleet() {
        return fleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetResponse)) {
            return false;
        }
        UpdateFleetResponse other = (UpdateFleetResponse) obj;
        return Objects.equals(fleet(), other.fleet());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateFleetResponse").add("Fleet", fleet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fleet":
            return Optional.of(clazz.cast(fleet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, UpdateFleetResponse> {
        /**
         * <p>
         * Information about the fleet.
         * </p>
         * 
         * @param fleet
         *        Information about the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(Fleet fleet);

        /**
         * <p>
         * Information about the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link Fleet.Builder} avoiding the need to create one
         * manually via {@link Fleet#builder()}.
         *
         * When the {@link Consumer} completes, {@link Fleet.Builder#build()} is called immediately and its result is
         * passed to {@link #fleet(Fleet)}.
         * 
         * @param fleet
         *        a consumer that will call methods on {@link Fleet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleet(Fleet)
         */
        default Builder fleet(Consumer<Fleet.Builder> fleet) {
            return fleet(Fleet.builder().apply(fleet).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private Fleet fleet;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetResponse model) {
            fleet(model.fleet);
        }

        public final Fleet.Builder getFleet() {
            return fleet != null ? fleet.toBuilder() : null;
        }

        @Override
        public final Builder fleet(Fleet fleet) {
            this.fleet = fleet;
            return this;
        }

        public final void setFleet(Fleet.BuilderImpl fleet) {
            this.fleet = fleet != null ? fleet.build() : null;
        }

        @Override
        public UpdateFleetResponse build() {
            return new UpdateFleetResponse(this);
        }
    }
}
