/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateStackResponse extends AppStreamResponse implements
        ToCopyableBuilder<UpdateStackResponse.Builder, UpdateStackResponse> {
    private final Stack stack;

    private UpdateStackResponse(BuilderImpl builder) {
        super(builder);
        this.stack = builder.stack;
    }

    /**
     * <p>
     * Information about the stack.
     * </p>
     * 
     * @return Information about the stack.
     */
    public Stack stack() {
        return stack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stack());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackResponse)) {
            return false;
        }
        UpdateStackResponse other = (UpdateStackResponse) obj;
        return Objects.equals(stack(), other.stack());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateStackResponse").add("Stack", stack()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stack":
            return Optional.of(clazz.cast(stack()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, UpdateStackResponse> {
        /**
         * <p>
         * Information about the stack.
         * </p>
         * 
         * @param stack
         *        Information about the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stack(Stack stack);

        /**
         * <p>
         * Information about the stack.
         * </p>
         * This is a convenience that creates an instance of the {@link Stack.Builder} avoiding the need to create one
         * manually via {@link Stack#builder()}.
         *
         * When the {@link Consumer} completes, {@link Stack.Builder#build()} is called immediately and its result is
         * passed to {@link #stack(Stack)}.
         * 
         * @param stack
         *        a consumer that will call methods on {@link Stack.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stack(Stack)
         */
        default Builder stack(Consumer<Stack.Builder> stack) {
            return stack(Stack.builder().apply(stack).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private Stack stack;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackResponse model) {
            stack(model.stack);
        }

        public final Stack.Builder getStack() {
            return stack != null ? stack.toBuilder() : null;
        }

        @Override
        public final Builder stack(Stack stack) {
            this.stack = stack;
            return this;
        }

        public final void setStack(Stack.BuilderImpl stack) {
            this.stack = stack != null ? stack.build() : null;
        }

        @Override
        public UpdateStackResponse build() {
            return new UpdateStackResponse(this);
        }
    }
}
