/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import java.time.Instant;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.ImageBuilder;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ImageBuilder} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ImageBuilderMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();

    private static final MarshallingInfo<String> IMAGEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageArn").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").isBinary(false).build();

    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> STATECHANGEREASON_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("StateChangeReason").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ENABLEDEFAULTINTERNETACCESS_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EnableDefaultInternetAccess").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DOMAINJOININFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DomainJoinInfo").isBinary(false).build();

    private static final MarshallingInfo<List> IMAGEBUILDERERRORS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageBuilderErrors").isBinary(false).build();

    private static final ImageBuilderMarshaller INSTANCE = new ImageBuilderMarshaller();

    private ImageBuilderMarshaller() {
    }

    public static ImageBuilderMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ImageBuilder imageBuilder, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(imageBuilder, "imageBuilder");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(imageBuilder.name(), NAME_BINDING);
            protocolMarshaller.marshall(imageBuilder.arn(), ARN_BINDING);
            protocolMarshaller.marshall(imageBuilder.imageArn(), IMAGEARN_BINDING);
            protocolMarshaller.marshall(imageBuilder.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(imageBuilder.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(imageBuilder.vpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall(imageBuilder.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(imageBuilder.platformString(), PLATFORM_BINDING);
            protocolMarshaller.marshall(imageBuilder.stateString(), STATE_BINDING);
            protocolMarshaller.marshall(imageBuilder.stateChangeReason(), STATECHANGEREASON_BINDING);
            protocolMarshaller.marshall(imageBuilder.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(imageBuilder.enableDefaultInternetAccess(), ENABLEDEFAULTINTERNETACCESS_BINDING);
            protocolMarshaller.marshall(imageBuilder.domainJoinInfo(), DOMAINJOININFO_BINDING);
            protocolMarshaller.marshall(imageBuilder.imageBuilderErrors(), IMAGEBUILDERERRORS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
