/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appstream.model.ResourceError;

public class ResourceErrorUnmarshaller
implements Unmarshaller<ResourceError, JsonUnmarshallerContext> {
    private static final ResourceErrorUnmarshaller INSTANCE = new ResourceErrorUnmarshaller();

    public ResourceError unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceError.Builder resourceErrorBuilder = ResourceError.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ErrorCode", targetDepth)) {
                    context.nextToken();
                    resourceErrorBuilder.errorCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ErrorMessage", targetDepth)) {
                    context.nextToken();
                    resourceErrorBuilder.errorMessage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ErrorTimestamp", targetDepth)) {
                    context.nextToken();
                    resourceErrorBuilder.errorTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceError)resourceErrorBuilder.build();
    }

    public static ResourceErrorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

