/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamingUrlResponse extends AppStreamResponse implements
        ToCopyableBuilder<CreateStreamingUrlResponse.Builder, CreateStreamingUrlResponse> {
    private static final SdkField<String> STREAMING_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingUrlResponse::streamingURL)).setter(setter(Builder::streamingURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingURL").build()).build();

    private static final SdkField<Instant> EXPIRES_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateStreamingUrlResponse::expires)).setter(setter(Builder::expires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expires").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_URL_FIELD,
            EXPIRES_FIELD));

    private final String streamingURL;

    private final Instant expires;

    private CreateStreamingUrlResponse(BuilderImpl builder) {
        super(builder);
        this.streamingURL = builder.streamingURL;
        this.expires = builder.expires;
    }

    /**
     * <p>
     * The URL to start the AppStream 2.0 streaming session.
     * </p>
     * 
     * @return The URL to start the AppStream 2.0 streaming session.
     */
    public String streamingURL() {
        return streamingURL;
    }

    /**
     * <p>
     * The elapsed time, in seconds after the Unix epoch, when this URL expires.
     * </p>
     * 
     * @return The elapsed time, in seconds after the Unix epoch, when this URL expires.
     */
    public Instant expires() {
        return expires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingURL());
        hashCode = 31 * hashCode + Objects.hashCode(expires());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingUrlResponse)) {
            return false;
        }
        CreateStreamingUrlResponse other = (CreateStreamingUrlResponse) obj;
        return Objects.equals(streamingURL(), other.streamingURL()) && Objects.equals(expires(), other.expires());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStreamingUrlResponse").add("StreamingURL", streamingURL()).add("Expires", expires())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingURL":
            return Optional.ofNullable(clazz.cast(streamingURL()));
        case "Expires":
            return Optional.ofNullable(clazz.cast(expires()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamingUrlResponse, T> g) {
        return obj -> g.apply((CreateStreamingUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStreamingUrlResponse> {
        /**
         * <p>
         * The URL to start the AppStream 2.0 streaming session.
         * </p>
         * 
         * @param streamingURL
         *        The URL to start the AppStream 2.0 streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingURL(String streamingURL);

        /**
         * <p>
         * The elapsed time, in seconds after the Unix epoch, when this URL expires.
         * </p>
         * 
         * @param expires
         *        The elapsed time, in seconds after the Unix epoch, when this URL expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expires(Instant expires);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private String streamingURL;

        private Instant expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingUrlResponse model) {
            super(model);
            streamingURL(model.streamingURL);
            expires(model.expires);
        }

        public final String getStreamingURL() {
            return streamingURL;
        }

        @Override
        public final Builder streamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
            return this;
        }

        public final void setStreamingURL(String streamingURL) {
            this.streamingURL = streamingURL;
        }

        public final Instant getExpires() {
            return expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        @Override
        public CreateStreamingUrlResponse build() {
            return new CreateStreamingUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
