/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamingUrlRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateStreamingUrlRequest.Builder, CreateStreamingUrlRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingUrlRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingUrlRequest::fleetName)).setter(setter(Builder::fleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingUrlRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingUrlRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<Long> VALIDITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateStreamingUrlRequest::validity)).setter(setter(Builder::validity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()).build();

    private static final SdkField<String> SESSION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamingUrlRequest::sessionContext)).setter(setter(Builder::sessionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            FLEET_NAME_FIELD, USER_ID_FIELD, APPLICATION_ID_FIELD, VALIDITY_FIELD, SESSION_CONTEXT_FIELD));

    private final String stackName;

    private final String fleetName;

    private final String userId;

    private final String applicationId;

    private final Long validity;

    private final String sessionContext;

    private CreateStreamingUrlRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.applicationId = builder.applicationId;
        this.validity = builder.validity;
        this.sessionContext = builder.sessionContext;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The identifier of the user.
     * </p>
     * 
     * @return The identifier of the user.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the application to launch after the session starts. This is the name that you specified as
     * <b>Name</b> in the Image Assistant.
     * </p>
     * 
     * @return The name of the application to launch after the session starts. This is the name that you specified as
     *         <b>Name</b> in the Image Assistant.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The
     * default is 60 seconds.
     * </p>
     * 
     * @return The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds.
     *         The default is 60 seconds.
     */
    public Long validity() {
        return validity;
    }

    /**
     * <p>
     * The session context. For more information, see <a href=
     * "https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters"
     * >Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * 
     * @return The session context. For more information, see <a href=
     *         "https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters"
     *         >Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public String sessionContext() {
        return sessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        hashCode = 31 * hashCode + Objects.hashCode(sessionContext());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingUrlRequest)) {
            return false;
        }
        CreateStreamingUrlRequest other = (CreateStreamingUrlRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(fleetName(), other.fleetName())
                && Objects.equals(userId(), other.userId()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(validity(), other.validity()) && Objects.equals(sessionContext(), other.sessionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStreamingUrlRequest").add("StackName", stackName()).add("FleetName", fleetName())
                .add("UserId", userId()).add("ApplicationId", applicationId()).add("Validity", validity())
                .add("SessionContext", sessionContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "FleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Validity":
            return Optional.ofNullable(clazz.cast(validity()));
        case "SessionContext":
            return Optional.ofNullable(clazz.cast(sessionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamingUrlRequest, T> g) {
        return obj -> g.apply((CreateStreamingUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStreamingUrlRequest> {
        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param stackName
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The identifier of the user.
         * </p>
         * 
         * @param userId
         *        The identifier of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name of the application to launch after the session starts. This is the name that you specified as
         * <b>Name</b> in the Image Assistant.
         * </p>
         * 
         * @param applicationId
         *        The name of the application to launch after the session starts. This is the name that you specified as
         *        <b>Name</b> in the Image Assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The
         * default is 60 seconds.
         * </p>
         * 
         * @param validity
         *        The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800
         *        seconds. The default is 60 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(Long validity);

        /**
         * <p>
         * The session context. For more information, see <a href=
         * "https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters"
         * >Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param sessionContext
         *        The session context. For more information, see <a href=
         *        "https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters"
         *        >Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionContext(String sessionContext);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String stackName;

        private String fleetName;

        private String userId;

        private String applicationId;

        private Long validity;

        private String sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingUrlRequest model) {
            super(model);
            stackName(model.stackName);
            fleetName(model.fleetName);
            userId(model.userId);
            applicationId(model.applicationId);
            validity(model.validity);
            sessionContext(model.sessionContext);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Long getValidity() {
            return validity;
        }

        @Override
        public final Builder validity(Long validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(Long validity) {
            this.validity = validity;
        }

        public final String getSessionContext() {
            return sessionContext;
        }

        @Override
        public final Builder sessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public final void setSessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamingUrlRequest build() {
            return new CreateStreamingUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
