/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> MESSAGE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::messageActionAsString)).setter(setter(Builder::messageAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAction").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUserRequest::authenticationTypeAsString)).setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            MESSAGE_ACTION_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, AUTHENTICATION_TYPE_FIELD));

    private final String userName;

    private final String messageAction;

    private final String firstName;

    private final String lastName;

    private final String authenticationType;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.messageAction = builder.messageAction;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.authenticationType = builder.authenticationType;
    }

    /**
     * <p>
     * The email address of the user.
     * </p>
     * <note>
     * <p>
     * Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the
     * same capitalization as the email address specified when their user pool account was created, a
     * "user does not exist" error message displays.
     * </p>
     * </note>
     * 
     * @return The email address of the user.</p> <note>
     *         <p>
     *         Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't
     *         use the same capitalization as the email address specified when their user pool account was created, a
     *         "user does not exist" error message displays.
     *         </p>
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The action to take for the welcome email that is sent to a user after the user is created in the user pool. If
     * you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the
     * user. If the value is null, the email is sent.
     * </p>
     * <note>
     * <p>
     * The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7
     * days, you must send them a new welcome email.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageAction}
     * will return {@link MessageAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageActionAsString}.
     * </p>
     * 
     * @return The action to take for the welcome email that is sent to a user after the user is created in the user
     *         pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or
     *         last name of the user. If the value is null, the email is sent. </p> <note>
     *         <p>
     *         The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords
     *         within 7 days, you must send them a new welcome email.
     *         </p>
     * @see MessageAction
     */
    public MessageAction messageAction() {
        return MessageAction.fromValue(messageAction);
    }

    /**
     * <p>
     * The action to take for the welcome email that is sent to a user after the user is created in the user pool. If
     * you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the
     * user. If the value is null, the email is sent.
     * </p>
     * <note>
     * <p>
     * The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7
     * days, you must send them a new welcome email.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageAction}
     * will return {@link MessageAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageActionAsString}.
     * </p>
     * 
     * @return The action to take for the welcome email that is sent to a user after the user is created in the user
     *         pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or
     *         last name of the user. If the value is null, the email is sent. </p> <note>
     *         <p>
     *         The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords
     *         within 7 days, you must send them a new welcome email.
     *         </p>
     * @see MessageAction
     */
    public String messageActionAsString() {
        return messageAction;
    }

    /**
     * <p>
     * The first name, or given name, of the user.
     * </p>
     * 
     * @return The first name, or given name, of the user.
     */
    public String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name, or surname, of the user.
     * </p>
     * 
     * @return The last name, or surname, of the user.
     */
    public String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The authentication type for the user. You must specify USERPOOL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the user. You must specify USERPOOL.
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type for the user. You must specify USERPOOL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the user. You must specify USERPOOL.
     * @see AuthenticationType
     */
    public String authenticationTypeAsString() {
        return authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(messageActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(userName(), other.userName())
                && Objects.equals(messageActionAsString(), other.messageActionAsString())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateUserRequest")
                .add("UserName", userName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MessageAction", messageActionAsString())
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthenticationType", authenticationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "MessageAction":
            return Optional.ofNullable(clazz.cast(messageActionAsString()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The email address of the user.
         * </p>
         * <note>
         * <p>
         * Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use
         * the same capitalization as the email address specified when their user pool account was created, a
         * "user does not exist" error message displays.
         * </p>
         * </note>
         * 
         * @param userName
         *        The email address of the user.</p> <note>
         *        <p>
         *        Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't
         *        use the same capitalization as the email address specified when their user pool account was created, a
         *        "user does not exist" error message displays.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The action to take for the welcome email that is sent to a user after the user is created in the user pool.
         * If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name
         * of the user. If the value is null, the email is sent.
         * </p>
         * <note>
         * <p>
         * The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords
         * within 7 days, you must send them a new welcome email.
         * </p>
         * </note>
         * 
         * @param messageAction
         *        The action to take for the welcome email that is sent to a user after the user is created in the user
         *        pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name
         *        or last name of the user. If the value is null, the email is sent. </p> <note>
         *        <p>
         *        The temporary password in the welcome email is valid for only 7 days. If users don’t set their
         *        passwords within 7 days, you must send them a new welcome email.
         *        </p>
         * @see MessageAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageAction
         */
        Builder messageAction(String messageAction);

        /**
         * <p>
         * The action to take for the welcome email that is sent to a user after the user is created in the user pool.
         * If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name
         * of the user. If the value is null, the email is sent.
         * </p>
         * <note>
         * <p>
         * The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords
         * within 7 days, you must send them a new welcome email.
         * </p>
         * </note>
         * 
         * @param messageAction
         *        The action to take for the welcome email that is sent to a user after the user is created in the user
         *        pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name
         *        or last name of the user. If the value is null, the email is sent. </p> <note>
         *        <p>
         *        The temporary password in the welcome email is valid for only 7 days. If users don’t set their
         *        passwords within 7 days, you must send them a new welcome email.
         *        </p>
         * @see MessageAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageAction
         */
        Builder messageAction(MessageAction messageAction);

        /**
         * <p>
         * The first name, or given name, of the user.
         * </p>
         * 
         * @param firstName
         *        The first name, or given name, of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name, or surname, of the user.
         * </p>
         * 
         * @param lastName
         *        The last name, or surname, of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The authentication type for the user. You must specify USERPOOL.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type for the user. You must specify USERPOOL.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type for the user. You must specify USERPOOL.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type for the user. You must specify USERPOOL.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String userName;

        private String messageAction;

        private String firstName;

        private String lastName;

        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            userName(model.userName);
            messageAction(model.messageAction);
            firstName(model.firstName);
            lastName(model.lastName);
            authenticationType(model.authenticationType);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getMessageAction() {
            return messageAction;
        }

        @Override
        public final Builder messageAction(String messageAction) {
            this.messageAction = messageAction;
            return this;
        }

        @Override
        public final Builder messageAction(MessageAction messageAction) {
            this.messageAction(messageAction == null ? null : messageAction.toString());
            return this;
        }

        public final void setMessageAction(String messageAction) {
            this.messageAction = messageAction;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
