/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the network details of the fleet or image builder instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkAccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkAccessConfiguration.Builder, NetworkAccessConfiguration> {
    private static final SdkField<String> ENI_PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkAccessConfiguration::eniPrivateIpAddress)).setter(setter(Builder::eniPrivateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniPrivateIpAddress").build())
            .build();

    private static final SdkField<String> ENI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkAccessConfiguration::eniId)).setter(setter(Builder::eniId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENI_PRIVATE_IP_ADDRESS_FIELD,
            ENI_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eniPrivateIpAddress;

    private final String eniId;

    private NetworkAccessConfiguration(BuilderImpl builder) {
        this.eniPrivateIpAddress = builder.eniPrivateIpAddress;
        this.eniId = builder.eniId;
    }

    /**
     * <p>
     * The private IP address of the elastic network interface that is attached to instances in your VPC.
     * </p>
     * 
     * @return The private IP address of the elastic network interface that is attached to instances in your VPC.
     */
    public String eniPrivateIpAddress() {
        return eniPrivateIpAddress;
    }

    /**
     * <p>
     * The resource identifier of the elastic network interface that is attached to instances in your VPC. All network
     * interfaces have the eni-xxxxxxxx resource identifier.
     * </p>
     * 
     * @return The resource identifier of the elastic network interface that is attached to instances in your VPC. All
     *         network interfaces have the eni-xxxxxxxx resource identifier.
     */
    public String eniId() {
        return eniId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eniPrivateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(eniId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAccessConfiguration)) {
            return false;
        }
        NetworkAccessConfiguration other = (NetworkAccessConfiguration) obj;
        return Objects.equals(eniPrivateIpAddress(), other.eniPrivateIpAddress()) && Objects.equals(eniId(), other.eniId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkAccessConfiguration").add("EniPrivateIpAddress", eniPrivateIpAddress())
                .add("EniId", eniId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EniPrivateIpAddress":
            return Optional.ofNullable(clazz.cast(eniPrivateIpAddress()));
        case "EniId":
            return Optional.ofNullable(clazz.cast(eniId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkAccessConfiguration, T> g) {
        return obj -> g.apply((NetworkAccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkAccessConfiguration> {
        /**
         * <p>
         * The private IP address of the elastic network interface that is attached to instances in your VPC.
         * </p>
         * 
         * @param eniPrivateIpAddress
         *        The private IP address of the elastic network interface that is attached to instances in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniPrivateIpAddress(String eniPrivateIpAddress);

        /**
         * <p>
         * The resource identifier of the elastic network interface that is attached to instances in your VPC. All
         * network interfaces have the eni-xxxxxxxx resource identifier.
         * </p>
         * 
         * @param eniId
         *        The resource identifier of the elastic network interface that is attached to instances in your VPC.
         *        All network interfaces have the eni-xxxxxxxx resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniId(String eniId);
    }

    static final class BuilderImpl implements Builder {
        private String eniPrivateIpAddress;

        private String eniId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAccessConfiguration model) {
            eniPrivateIpAddress(model.eniPrivateIpAddress);
            eniId(model.eniId);
        }

        public final String getEniPrivateIpAddress() {
            return eniPrivateIpAddress;
        }

        @Override
        public final Builder eniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
            return this;
        }

        public final void setEniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
        }

        public final String getEniId() {
            return eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        @Override
        public NetworkAccessConfiguration build() {
            return new NetworkAccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
