/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a user in the user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(User::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(User::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(User::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::authenticationTypeAsString)).setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, USER_NAME_FIELD,
            ENABLED_FIELD, STATUS_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, CREATED_TIME_FIELD, AUTHENTICATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String userName;

    private final Boolean enabled;

    private final String status;

    private final String firstName;

    private final String lastName;

    private final Instant createdTime;

    private final String authenticationType;

    private User(BuilderImpl builder) {
        this.arn = builder.arn;
        this.userName = builder.userName;
        this.enabled = builder.enabled;
        this.status = builder.status;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.createdTime = builder.createdTime;
        this.authenticationType = builder.authenticationType;
    }

    /**
     * <p>
     * The ARN of the user.
     * </p>
     * 
     * @return The ARN of the user.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The email address of the user.
     * </p>
     * <note>
     * <p>
     * Users' email addresses are case-sensitive.
     * </p>
     * </note>
     * 
     * @return The email address of the user.</p> <note>
     *         <p>
     *         Users' email addresses are case-sensitive.
     *         </p>
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * Specifies whether the user in the user pool is enabled.
     * </p>
     * 
     * @return Specifies whether the user in the user pool is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The status of the user in the user pool. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNCONFIRMED – The user is created but not confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIRMED – The user is confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVED – The user is no longer active.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPROMISED – The user is disabled because of a potential security threat.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN – The user status is not known.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the user in the user pool. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNCONFIRMED – The user is created but not confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIRMED – The user is confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVED – The user is no longer active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPROMISED – The user is disabled because of a potential security threat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN – The user status is not known.
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The first name, or given name, of the user.
     * </p>
     * 
     * @return The first name, or given name, of the user.
     */
    public String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name, or surname, of the user.
     * </p>
     * 
     * @return The last name, or surname, of the user.
     */
    public String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The date and time the user was created in the user pool.
     * </p>
     * 
     * @return The date and time the user was created in the user pool.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The authentication type for the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the user.
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type for the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the user.
     * @see AuthenticationType
     */
    public String authenticationTypeAsString() {
        return authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(userName(), other.userName())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(status(), other.status())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("User").add("Arn", arn())
                .add("UserName", userName() == null ? null : "*** Sensitive Data Redacted ***").add("Enabled", enabled())
                .add("Status", status()).add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***").add("CreatedTime", createdTime())
                .add("AuthenticationType", authenticationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The ARN of the user.
         * </p>
         * 
         * @param arn
         *        The ARN of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The email address of the user.
         * </p>
         * <note>
         * <p>
         * Users' email addresses are case-sensitive.
         * </p>
         * </note>
         * 
         * @param userName
         *        The email address of the user.</p> <note>
         *        <p>
         *        Users' email addresses are case-sensitive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Specifies whether the user in the user pool is enabled.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the user in the user pool is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The status of the user in the user pool. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNCONFIRMED – The user is created but not confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIRMED – The user is confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVED – The user is no longer active.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPROMISED – The user is disabled because of a potential security threat.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN – The user status is not known.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the user in the user pool. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNCONFIRMED – The user is created but not confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIRMED – The user is confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVED – The user is no longer active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPROMISED – The user is disabled because of a potential security threat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN – The user status is not known.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The first name, or given name, of the user.
         * </p>
         * 
         * @param firstName
         *        The first name, or given name, of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name, or surname, of the user.
         * </p>
         * 
         * @param lastName
         *        The last name, or surname, of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The date and time the user was created in the user pool.
         * </p>
         * 
         * @param createdTime
         *        The date and time the user was created in the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The authentication type for the user.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type for the user.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type for the user.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type for the user.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String userName;

        private Boolean enabled;

        private String status;

        private String firstName;

        private String lastName;

        private Instant createdTime;

        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            arn(model.arn);
            userName(model.userName);
            enabled(model.enabled);
            status(model.status);
            firstName(model.firstName);
            lastName(model.lastName);
            createdTime(model.createdTime);
            authenticationType(model.authenticationType);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
