/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stack implements SdkPojo, Serializable, ToCopyableBuilder<Stack.Builder, Stack> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stack::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stack::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stack::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stack::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Stack::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField
            .<List<StorageConnector>> builder(MarshallingType.LIST)
            .getter(getter(Stack::storageConnectors))
            .setter(setter(Builder::storageConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageConnector> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageConnector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stack::redirectURL)).setter(setter(Builder::redirectURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectURL").build()).build();

    private static final SdkField<String> FEEDBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stack::feedbackURL)).setter(setter(Builder::feedbackURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackURL").build()).build();

    private static final SdkField<List<StackError>> STACK_ERRORS_FIELD = SdkField
            .<List<StackError>> builder(MarshallingType.LIST)
            .getter(getter(Stack::stackErrors))
            .setter(setter(Builder::stackErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackError> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField
            .<List<UserSetting>> builder(MarshallingType.LIST)
            .getter(getter(Stack::userSettings))
            .setter(setter(Builder::userSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationSettingsResponse> APPLICATION_SETTINGS_FIELD = SdkField
            .<ApplicationSettingsResponse> builder(MarshallingType.SDK_POJO).getter(getter(Stack::applicationSettings))
            .setter(setter(Builder::applicationSettings)).constructor(ApplicationSettingsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build())
            .build();

    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField
            .<List<AccessEndpoint>> builder(MarshallingType.LIST)
            .getter(getter(Stack::accessEndpoints))
            .setter(setter(Builder::accessEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EMBED_HOST_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Stack::embedHostDomains))
            .setter(setter(Builder::embedHostDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmbedHostDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, CREATED_TIME_FIELD, STORAGE_CONNECTORS_FIELD, REDIRECT_URL_FIELD,
            FEEDBACK_URL_FIELD, STACK_ERRORS_FIELD, USER_SETTINGS_FIELD, APPLICATION_SETTINGS_FIELD, ACCESS_ENDPOINTS_FIELD,
            EMBED_HOST_DOMAINS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String displayName;

    private final Instant createdTime;

    private final List<StorageConnector> storageConnectors;

    private final String redirectURL;

    private final String feedbackURL;

    private final List<StackError> stackErrors;

    private final List<UserSetting> userSettings;

    private final ApplicationSettingsResponse applicationSettings;

    private final List<AccessEndpoint> accessEndpoints;

    private final List<String> embedHostDomains;

    private Stack(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.storageConnectors = builder.storageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.stackErrors = builder.stackErrors;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
        this.accessEndpoints = builder.accessEndpoints;
        this.embedHostDomains = builder.embedHostDomains;
    }

    /**
     * <p>
     * The ARN of the stack.
     * </p>
     * 
     * @return The ARN of the stack.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description to display.
     * </p>
     * 
     * @return The description to display.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The stack name to display.
     * </p>
     * 
     * @return The stack name to display.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The time the stack was created.
     * </p>
     * 
     * @return The time the stack was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * Returns true if the StorageConnectors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStorageConnectors() {
        return storageConnectors != null && !(storageConnectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The storage connectors to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStorageConnectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The storage connectors to enable.
     */
    public List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * The URL that users are redirected to after their streaming session ends.
     * </p>
     * 
     * @return The URL that users are redirected to after their streaming session ends.
     */
    public String redirectURL() {
        return redirectURL;
    }

    /**
     * <p>
     * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send
     * Feedback link is displayed.
     * </p>
     * 
     * @return The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no
     *         Send Feedback link is displayed.
     */
    public String feedbackURL() {
        return feedbackURL;
    }

    /**
     * Returns true if the StackErrors property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStackErrors() {
        return stackErrors != null && !(stackErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors for the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The errors for the stack.
     */
    public List<StackError> stackErrors() {
        return stackErrors;
    }

    /**
     * Returns true if the UserSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserSettings() {
        return userSettings != null && !(userSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions that are enabled or disabled for users during their streaming sessions. By default these actions are
     * enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions that are enabled or disabled for users during their streaming sessions. By default these
     *         actions are enabled.
     */
    public List<UserSetting> userSettings() {
        return userSettings;
    }

    /**
     * <p>
     * The persistent application settings for users of the stack.
     * </p>
     * 
     * @return The persistent application settings for users of the stack.
     */
    public ApplicationSettingsResponse applicationSettings() {
        return applicationSettings;
    }

    /**
     * Returns true if the AccessEndpoints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAccessEndpoints() {
        return accessEndpoints != null && !(accessEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream
     * 2.0 only through the specified endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccessEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to
     *         AppStream 2.0 only through the specified endpoints.
     */
    public List<AccessEndpoint> accessEndpoints() {
        return accessEndpoints;
    }

    /**
     * Returns true if the EmbedHostDomains property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEmbedHostDomains() {
        return embedHostDomains != null && !(embedHostDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
     * that you want to host embedded AppStream 2.0 streaming sessions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEmbedHostDomains()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
     *         domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    public List<String> embedHostDomains() {
        return embedHostDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(storageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(stackErrors());
        hashCode = 31 * hashCode + Objects.hashCode(userSettings());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(accessEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(embedHostDomains());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(storageConnectors(), other.storageConnectors())
                && Objects.equals(redirectURL(), other.redirectURL()) && Objects.equals(feedbackURL(), other.feedbackURL())
                && Objects.equals(stackErrors(), other.stackErrors()) && Objects.equals(userSettings(), other.userSettings())
                && Objects.equals(applicationSettings(), other.applicationSettings())
                && Objects.equals(accessEndpoints(), other.accessEndpoints())
                && Objects.equals(embedHostDomains(), other.embedHostDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Stack").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("DisplayName", displayName()).add("CreatedTime", createdTime())
                .add("StorageConnectors", storageConnectors()).add("RedirectURL", redirectURL())
                .add("FeedbackURL", feedbackURL()).add("StackErrors", stackErrors()).add("UserSettings", userSettings())
                .add("ApplicationSettings", applicationSettings()).add("AccessEndpoints", accessEndpoints())
                .add("EmbedHostDomains", embedHostDomains()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "StorageConnectors":
            return Optional.ofNullable(clazz.cast(storageConnectors()));
        case "RedirectURL":
            return Optional.ofNullable(clazz.cast(redirectURL()));
        case "FeedbackURL":
            return Optional.ofNullable(clazz.cast(feedbackURL()));
        case "StackErrors":
            return Optional.ofNullable(clazz.cast(stackErrors()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        case "ApplicationSettings":
            return Optional.ofNullable(clazz.cast(applicationSettings()));
        case "AccessEndpoints":
            return Optional.ofNullable(clazz.cast(accessEndpoints()));
        case "EmbedHostDomains":
            return Optional.ofNullable(clazz.cast(embedHostDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stack, T> g) {
        return obj -> g.apply((Stack) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stack> {
        /**
         * <p>
         * The ARN of the stack.
         * </p>
         * 
         * @param arn
         *        The ARN of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param name
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description to display.
         * </p>
         * 
         * @param description
         *        The description to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stack name to display.
         * </p>
         * 
         * @param displayName
         *        The stack name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The time the stack was created.
         * </p>
         * 
         * @param createdTime
         *        The time the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StorageConnector>.Builder} avoiding the
         * need to create one manually via {@link List<StorageConnector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageConnector>.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConnectors(List<StorageConnector>)}.
         * 
         * @param storageConnectors
         *        a consumer that will call methods on {@link List<StorageConnector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConnectors(List<StorageConnector>)
         */
        Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors);

        /**
         * <p>
         * The URL that users are redirected to after their streaming session ends.
         * </p>
         * 
         * @param redirectURL
         *        The URL that users are redirected to after their streaming session ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectURL(String redirectURL);

        /**
         * <p>
         * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send
         * Feedback link is displayed.
         * </p>
         * 
         * @param feedbackURL
         *        The URL that users are redirected to after they click the Send Feedback link. If no URL is specified,
         *        no Send Feedback link is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackURL(String feedbackURL);

        /**
         * <p>
         * The errors for the stack.
         * </p>
         * 
         * @param stackErrors
         *        The errors for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackErrors(Collection<StackError> stackErrors);

        /**
         * <p>
         * The errors for the stack.
         * </p>
         * 
         * @param stackErrors
         *        The errors for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackErrors(StackError... stackErrors);

        /**
         * <p>
         * The errors for the stack.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackError>.Builder} avoiding the need to
         * create one manually via {@link List<StackError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackError>.Builder#build()} is called immediately and its
         * result is passed to {@link #stackErrors(List<StackError>)}.
         * 
         * @param stackErrors
         *        a consumer that will call methods on {@link List<StackError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackErrors(List<StackError>)
         */
        Builder stackErrors(Consumer<StackError.Builder>... stackErrors);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(Collection<UserSetting> userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSetting... userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default these actions
         * are enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserSetting>.Builder} avoiding the need to
         * create one manually via {@link List<UserSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserSetting>.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(List<UserSetting>)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link List<UserSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(List<UserSetting>)
         */
        Builder userSettings(Consumer<UserSetting.Builder>... userSettings);

        /**
         * <p>
         * The persistent application settings for users of the stack.
         * </p>
         * 
         * @param applicationSettings
         *        The persistent application settings for users of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSettings(ApplicationSettingsResponse applicationSettings);

        /**
         * <p>
         * The persistent application settings for users of the stack.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSettingsResponse.Builder} avoiding
         * the need to create one manually via {@link ApplicationSettingsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSettingsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationSettings(ApplicationSettingsResponse)}.
         * 
         * @param applicationSettings
         *        a consumer that will call methods on {@link ApplicationSettingsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSettings(ApplicationSettingsResponse)
         */
        default Builder applicationSettings(Consumer<ApplicationSettingsResponse.Builder> applicationSettings) {
            return applicationSettings(ApplicationSettingsResponse.builder().applyMutation(applicationSettings).build());
        }

        /**
         * <p>
         * The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to
         * AppStream 2.0 only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to
         *        AppStream 2.0 only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints);

        /**
         * <p>
         * The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to
         * AppStream 2.0 only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to
         *        AppStream 2.0 only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(AccessEndpoint... accessEndpoints);

        /**
         * <p>
         * The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to
         * AppStream 2.0 only through the specified endpoints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessEndpoint>.Builder} avoiding the need
         * to create one manually via {@link List<AccessEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #accessEndpoints(List<AccessEndpoint>)}.
         * 
         * @param accessEndpoints
         *        a consumer that will call methods on {@link List<AccessEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessEndpoints(List<AccessEndpoint>)
         */
        Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints);

        /**
         * <p>
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
         * that you want to host embedded AppStream 2.0 streaming sessions.
         * </p>
         * 
         * @param embedHostDomains
         *        The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
         *        domains that you want to host embedded AppStream 2.0 streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embedHostDomains(Collection<String> embedHostDomains);

        /**
         * <p>
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
         * that you want to host embedded AppStream 2.0 streaming sessions.
         * </p>
         * 
         * @param embedHostDomains
         *        The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
         *        domains that you want to host embedded AppStream 2.0 streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embedHostDomains(String... embedHostDomains);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String displayName;

        private Instant createdTime;

        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();

        private String redirectURL;

        private String feedbackURL;

        private List<StackError> stackErrors = DefaultSdkAutoConstructList.getInstance();

        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();

        private ApplicationSettingsResponse applicationSettings;

        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> embedHostDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            displayName(model.displayName);
            createdTime(model.createdTime);
            storageConnectors(model.storageConnectors);
            redirectURL(model.redirectURL);
            feedbackURL(model.feedbackURL);
            stackErrors(model.stackErrors);
            userSettings(model.userSettings);
            applicationSettings(model.applicationSettings);
            accessEndpoints(model.accessEndpoints);
            embedHostDomains(model.embedHostDomains);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return storageConnectors != null ? storageConnectors.stream().map(StorageConnector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors) {
            storageConnectors(Stream.of(storageConnectors).map(c -> StorageConnector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final String getRedirectURL() {
            return redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        public final String getFeedbackURL() {
            return feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        public final Collection<StackError.Builder> getStackErrors() {
            return stackErrors != null ? stackErrors.stream().map(StackError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackErrors(Collection<StackError> stackErrors) {
            this.stackErrors = StackErrorsCopier.copy(stackErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackErrors(StackError... stackErrors) {
            stackErrors(Arrays.asList(stackErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackErrors(Consumer<StackError.Builder>... stackErrors) {
            stackErrors(Stream.of(stackErrors).map(c -> StackError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStackErrors(Collection<StackError.BuilderImpl> stackErrors) {
            this.stackErrors = StackErrorsCopier.copyFromBuilder(stackErrors);
        }

        public final Collection<UserSetting.Builder> getUserSettings() {
            return userSettings != null ? userSettings.stream().map(UserSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting... userSettings) {
            userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder>... userSettings) {
            userSettings(Stream.of(userSettings).map(c -> UserSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        public final ApplicationSettingsResponse.Builder getApplicationSettings() {
            return applicationSettings != null ? applicationSettings.toBuilder() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsResponse applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final void setApplicationSettings(ApplicationSettingsResponse.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        public final Collection<AccessEndpoint.Builder> getAccessEndpoints() {
            return accessEndpoints != null ? accessEndpoints.stream().map(AccessEndpoint::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint... accessEndpoints) {
            accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints) {
            accessEndpoints(Stream.of(accessEndpoints).map(c -> AccessEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        public final Collection<String> getEmbedHostDomains() {
            return embedHostDomains;
        }

        @Override
        public final Builder embedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embedHostDomains(String... embedHostDomains) {
            embedHostDomains(Arrays.asList(embedHostDomains));
            return this;
        }

        public final void setEmbedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
        }

        @Override
        public Stack build() {
            return new Stack(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
