/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateUserStackRequest extends AppStreamRequest implements
        ToCopyableBuilder<BatchAssociateUserStackRequest.Builder, BatchAssociateUserStackRequest> {
    private static final SdkField<List<UserStackAssociation>> USER_STACK_ASSOCIATIONS_FIELD = SdkField
            .<List<UserStackAssociation>> builder(MarshallingType.LIST)
            .memberName("UserStackAssociations")
            .getter(getter(BatchAssociateUserStackRequest::userStackAssociations))
            .setter(setter(Builder::userStackAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStackAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserStackAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserStackAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(USER_STACK_ASSOCIATIONS_FIELD));

    private final List<UserStackAssociation> userStackAssociations;

    private BatchAssociateUserStackRequest(BuilderImpl builder) {
        super(builder);
        this.userStackAssociations = builder.userStackAssociations;
    }

    /**
     * Returns true if the UserStackAssociations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUserStackAssociations() {
        return userStackAssociations != null && !(userStackAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of UserStackAssociation objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserStackAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of UserStackAssociation objects.
     */
    public List<UserStackAssociation> userStackAssociations() {
        return userStackAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserStackAssociations() ? userStackAssociations() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateUserStackRequest)) {
            return false;
        }
        BatchAssociateUserStackRequest other = (BatchAssociateUserStackRequest) obj;
        return hasUserStackAssociations() == other.hasUserStackAssociations()
                && Objects.equals(userStackAssociations(), other.userStackAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchAssociateUserStackRequest")
                .add("UserStackAssociations", hasUserStackAssociations() ? userStackAssociations() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserStackAssociations":
            return Optional.ofNullable(clazz.cast(userStackAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateUserStackRequest, T> g) {
        return obj -> g.apply((BatchAssociateUserStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchAssociateUserStackRequest> {
        /**
         * <p>
         * The list of UserStackAssociation objects.
         * </p>
         * 
         * @param userStackAssociations
         *        The list of UserStackAssociation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStackAssociations(Collection<UserStackAssociation> userStackAssociations);

        /**
         * <p>
         * The list of UserStackAssociation objects.
         * </p>
         * 
         * @param userStackAssociations
         *        The list of UserStackAssociation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStackAssociations(UserStackAssociation... userStackAssociations);

        /**
         * <p>
         * The list of UserStackAssociation objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserStackAssociation>.Builder} avoiding the
         * need to create one manually via {@link List<UserStackAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserStackAssociation>.Builder#build()} is called immediately
         * and its result is passed to {@link #userStackAssociations(List<UserStackAssociation>)}.
         * 
         * @param userStackAssociations
         *        a consumer that will call methods on {@link List<UserStackAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userStackAssociations(List<UserStackAssociation>)
         */
        Builder userStackAssociations(Consumer<UserStackAssociation.Builder>... userStackAssociations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private List<UserStackAssociation> userStackAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateUserStackRequest model) {
            super(model);
            userStackAssociations(model.userStackAssociations);
        }

        public final Collection<UserStackAssociation.Builder> getUserStackAssociations() {
            if (userStackAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return userStackAssociations != null ? userStackAssociations.stream().map(UserStackAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userStackAssociations(Collection<UserStackAssociation> userStackAssociations) {
            this.userStackAssociations = UserStackAssociationListCopier.copy(userStackAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userStackAssociations(UserStackAssociation... userStackAssociations) {
            userStackAssociations(Arrays.asList(userStackAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userStackAssociations(Consumer<UserStackAssociation.Builder>... userStackAssociations) {
            userStackAssociations(Stream.of(userStackAssociations)
                    .map(c -> UserStackAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserStackAssociations(Collection<UserStackAssociation.BuilderImpl> userStackAssociations) {
            this.userStackAssociations = UserStackAssociationListCopier.copyFromBuilder(userStackAssociations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateUserStackRequest build() {
            return new BatchAssociateUserStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
