/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagePermissionsResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeImagePermissionsResponse.Builder, DescribeImagePermissionsResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeImagePermissionsResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<SharedImagePermissions>> SHARED_IMAGE_PERMISSIONS_LIST_FIELD = SdkField
            .<List<SharedImagePermissions>> builder(MarshallingType.LIST)
            .memberName("SharedImagePermissionsList")
            .getter(getter(DescribeImagePermissionsResponse::sharedImagePermissionsList))
            .setter(setter(Builder::sharedImagePermissionsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedImagePermissionsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SharedImagePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(SharedImagePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeImagePermissionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SHARED_IMAGE_PERMISSIONS_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final String name;

    private final List<SharedImagePermissions> sharedImagePermissionsList;

    private final String nextToken;

    private DescribeImagePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sharedImagePermissionsList = builder.sharedImagePermissionsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the private image.
     * </p>
     * 
     * @return The name of the private image.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the SharedImagePermissionsList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasSharedImagePermissionsList() {
        return sharedImagePermissionsList != null && !(sharedImagePermissionsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions for a private image that you own.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSharedImagePermissionsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions for a private image that you own.
     */
    public List<SharedImagePermissions> sharedImagePermissionsList() {
        return sharedImagePermissionsList;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedImagePermissionsList() ? sharedImagePermissionsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagePermissionsResponse)) {
            return false;
        }
        DescribeImagePermissionsResponse other = (DescribeImagePermissionsResponse) obj;
        return Objects.equals(name(), other.name()) && hasSharedImagePermissionsList() == other.hasSharedImagePermissionsList()
                && Objects.equals(sharedImagePermissionsList(), other.sharedImagePermissionsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeImagePermissionsResponse").add("Name", name())
                .add("SharedImagePermissionsList", hasSharedImagePermissionsList() ? sharedImagePermissionsList() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SharedImagePermissionsList":
            return Optional.ofNullable(clazz.cast(sharedImagePermissionsList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeImagePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeImagePermissionsResponse> {
        /**
         * <p>
         * The name of the private image.
         * </p>
         * 
         * @param name
         *        The name of the private image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The permissions for a private image that you own.
         * </p>
         * 
         * @param sharedImagePermissionsList
         *        The permissions for a private image that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedImagePermissionsList(Collection<SharedImagePermissions> sharedImagePermissionsList);

        /**
         * <p>
         * The permissions for a private image that you own.
         * </p>
         * 
         * @param sharedImagePermissionsList
         *        The permissions for a private image that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedImagePermissionsList(SharedImagePermissions... sharedImagePermissionsList);

        /**
         * <p>
         * The permissions for a private image that you own.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SharedImagePermissions>.Builder} avoiding
         * the need to create one manually via {@link List<SharedImagePermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SharedImagePermissions>.Builder#build()} is called
         * immediately and its result is passed to {@link #sharedImagePermissionsList(List<SharedImagePermissions>)}.
         * 
         * @param sharedImagePermissionsList
         *        a consumer that will call methods on {@link List<SharedImagePermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharedImagePermissionsList(List<SharedImagePermissions>)
         */
        Builder sharedImagePermissionsList(Consumer<SharedImagePermissions.Builder>... sharedImagePermissionsList);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private String name;

        private List<SharedImagePermissions> sharedImagePermissionsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagePermissionsResponse model) {
            super(model);
            name(model.name);
            sharedImagePermissionsList(model.sharedImagePermissionsList);
            nextToken(model.nextToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SharedImagePermissions.Builder> getSharedImagePermissionsList() {
            if (sharedImagePermissionsList instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedImagePermissionsList != null ? sharedImagePermissionsList.stream()
                    .map(SharedImagePermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sharedImagePermissionsList(Collection<SharedImagePermissions> sharedImagePermissionsList) {
            this.sharedImagePermissionsList = SharedImagePermissionsListCopier.copy(sharedImagePermissionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedImagePermissionsList(SharedImagePermissions... sharedImagePermissionsList) {
            sharedImagePermissionsList(Arrays.asList(sharedImagePermissionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedImagePermissionsList(Consumer<SharedImagePermissions.Builder>... sharedImagePermissionsList) {
            sharedImagePermissionsList(Stream.of(sharedImagePermissionsList)
                    .map(c -> SharedImagePermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSharedImagePermissionsList(Collection<SharedImagePermissions.BuilderImpl> sharedImagePermissionsList) {
            this.sharedImagePermissionsList = SharedImagePermissionsListCopier.copyFromBuilder(sharedImagePermissionsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImagePermissionsResponse build() {
            return new DescribeImagePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
