/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the permissions for an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImagePermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<ImagePermissions.Builder, ImagePermissions> {
    private static final SdkField<Boolean> ALLOW_FLEET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowFleet").getter(getter(ImagePermissions::allowFleet)).setter(setter(Builder::allowFleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowFleet").build()).build();

    private static final SdkField<Boolean> ALLOW_IMAGE_BUILDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowImageBuilder").getter(getter(ImagePermissions::allowImageBuilder))
            .setter(setter(Builder::allowImageBuilder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowImageBuilder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FLEET_FIELD,
            ALLOW_IMAGE_BUILDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowFleet;

    private final Boolean allowImageBuilder;

    private ImagePermissions(BuilderImpl builder) {
        this.allowFleet = builder.allowFleet;
        this.allowImageBuilder = builder.allowImageBuilder;
    }

    /**
     * <p>
     * Indicates whether the image can be used for a fleet.
     * </p>
     * 
     * @return Indicates whether the image can be used for a fleet.
     */
    public Boolean allowFleet() {
        return allowFleet;
    }

    /**
     * <p>
     * Indicates whether the image can be used for an image builder.
     * </p>
     * 
     * @return Indicates whether the image can be used for an image builder.
     */
    public Boolean allowImageBuilder() {
        return allowImageBuilder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowFleet());
        hashCode = 31 * hashCode + Objects.hashCode(allowImageBuilder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImagePermissions)) {
            return false;
        }
        ImagePermissions other = (ImagePermissions) obj;
        return Objects.equals(allowFleet(), other.allowFleet()) && Objects.equals(allowImageBuilder(), other.allowImageBuilder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImagePermissions").add("AllowFleet", allowFleet()).add("AllowImageBuilder", allowImageBuilder())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowFleet":
            return Optional.ofNullable(clazz.cast(allowFleet()));
        case "allowImageBuilder":
            return Optional.ofNullable(clazz.cast(allowImageBuilder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImagePermissions, T> g) {
        return obj -> g.apply((ImagePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImagePermissions> {
        /**
         * <p>
         * Indicates whether the image can be used for a fleet.
         * </p>
         * 
         * @param allowFleet
         *        Indicates whether the image can be used for a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowFleet(Boolean allowFleet);

        /**
         * <p>
         * Indicates whether the image can be used for an image builder.
         * </p>
         * 
         * @param allowImageBuilder
         *        Indicates whether the image can be used for an image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowImageBuilder(Boolean allowImageBuilder);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowFleet;

        private Boolean allowImageBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(ImagePermissions model) {
            allowFleet(model.allowFleet);
            allowImageBuilder(model.allowImageBuilder);
        }

        public final Boolean getAllowFleet() {
            return allowFleet;
        }

        @Override
        public final Builder allowFleet(Boolean allowFleet) {
            this.allowFleet = allowFleet;
            return this;
        }

        public final void setAllowFleet(Boolean allowFleet) {
            this.allowFleet = allowFleet;
        }

        public final Boolean getAllowImageBuilder() {
            return allowImageBuilder;
        }

        @Override
        public final Builder allowImageBuilder(Boolean allowImageBuilder) {
            this.allowImageBuilder = allowImageBuilder;
            return this;
        }

        public final void setAllowImageBuilder(Boolean allowImageBuilder) {
            this.allowImageBuilder = allowImageBuilder;
        }

        @Override
        public ImagePermissions build() {
            return new ImagePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
