/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a user in the user pool and the associated stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserStackAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<UserStackAssociation.Builder, UserStackAssociation> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(UserStackAssociation::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UserStackAssociation::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(UserStackAssociation::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<Boolean> SEND_EMAIL_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendEmailNotification").getter(getter(UserStackAssociation::sendEmailNotification))
            .setter(setter(Builder::sendEmailNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendEmailNotification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            USER_NAME_FIELD, AUTHENTICATION_TYPE_FIELD, SEND_EMAIL_NOTIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackName;

    private final String userName;

    private final String authenticationType;

    private final Boolean sendEmailNotification;

    private UserStackAssociation(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.userName = builder.userName;
        this.authenticationType = builder.authenticationType;
        this.sendEmailNotification = builder.sendEmailNotification;
    }

    /**
     * <p>
     * The name of the stack that is associated with the user.
     * </p>
     * 
     * @return The name of the stack that is associated with the user.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The email address of the user who is associated with the stack.
     * </p>
     * <note>
     * <p>
     * Users' email addresses are case-sensitive.
     * </p>
     * </note>
     * 
     * @return The email address of the user who is associated with the stack.</p> <note>
     *         <p>
     *         Users' email addresses are case-sensitive.
     *         </p>
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The authentication type for the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the user.
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type for the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the user.
     * @see AuthenticationType
     */
    public String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * Specifies whether a welcome email is sent to a user after the user is created in the user pool.
     * </p>
     * 
     * @return Specifies whether a welcome email is sent to a user after the user is created in the user pool.
     */
    public Boolean sendEmailNotification() {
        return sendEmailNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sendEmailNotification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserStackAssociation)) {
            return false;
        }
        UserStackAssociation other = (UserStackAssociation) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(userName(), other.userName())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(sendEmailNotification(), other.sendEmailNotification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserStackAssociation").add("StackName", stackName())
                .add("UserName", userName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthenticationType", authenticationTypeAsString()).add("SendEmailNotification", sendEmailNotification())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "SendEmailNotification":
            return Optional.ofNullable(clazz.cast(sendEmailNotification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserStackAssociation, T> g) {
        return obj -> g.apply((UserStackAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserStackAssociation> {
        /**
         * <p>
         * The name of the stack that is associated with the user.
         * </p>
         * 
         * @param stackName
         *        The name of the stack that is associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The email address of the user who is associated with the stack.
         * </p>
         * <note>
         * <p>
         * Users' email addresses are case-sensitive.
         * </p>
         * </note>
         * 
         * @param userName
         *        The email address of the user who is associated with the stack.</p> <note>
         *        <p>
         *        Users' email addresses are case-sensitive.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The authentication type for the user.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type for the user.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type for the user.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type for the user.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * Specifies whether a welcome email is sent to a user after the user is created in the user pool.
         * </p>
         * 
         * @param sendEmailNotification
         *        Specifies whether a welcome email is sent to a user after the user is created in the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendEmailNotification(Boolean sendEmailNotification);
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private String userName;

        private String authenticationType;

        private Boolean sendEmailNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UserStackAssociation model) {
            stackName(model.stackName);
            userName(model.userName);
            authenticationType(model.authenticationType);
            sendEmailNotification(model.sendEmailNotification);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final Boolean getSendEmailNotification() {
            return sendEmailNotification;
        }

        @Override
        public final Builder sendEmailNotification(Boolean sendEmailNotification) {
            this.sendEmailNotification = sendEmailNotification;
            return this;
        }

        public final void setSendEmailNotification(Boolean sendEmailNotification) {
            this.sendEmailNotification = sendEmailNotification;
        }

        @Override
        public UserStackAssociation build() {
            return new UserStackAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
