/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImageBuilderResponse extends AppStreamResponse implements
        ToCopyableBuilder<StartImageBuilderResponse.Builder, StartImageBuilderResponse> {
    private static final SdkField<ImageBuilder> IMAGE_BUILDER_FIELD = SdkField.<ImageBuilder> builder(MarshallingType.SDK_POJO)
            .memberName("ImageBuilder").getter(getter(StartImageBuilderResponse::imageBuilder))
            .setter(setter(Builder::imageBuilder)).constructor(ImageBuilder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_BUILDER_FIELD));

    private final ImageBuilder imageBuilder;

    private StartImageBuilderResponse(BuilderImpl builder) {
        super(builder);
        this.imageBuilder = builder.imageBuilder;
    }

    /**
     * <p>
     * Information about the image builder.
     * </p>
     * 
     * @return Information about the image builder.
     */
    public ImageBuilder imageBuilder() {
        return imageBuilder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageBuilder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImageBuilderResponse)) {
            return false;
        }
        StartImageBuilderResponse other = (StartImageBuilderResponse) obj;
        return Objects.equals(imageBuilder(), other.imageBuilder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartImageBuilderResponse").add("ImageBuilder", imageBuilder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageBuilder":
            return Optional.ofNullable(clazz.cast(imageBuilder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImageBuilderResponse, T> g) {
        return obj -> g.apply((StartImageBuilderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartImageBuilderResponse> {
        /**
         * <p>
         * Information about the image builder.
         * </p>
         * 
         * @param imageBuilder
         *        Information about the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilder(ImageBuilder imageBuilder);

        /**
         * <p>
         * Information about the image builder.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageBuilder.Builder} avoiding the need to
         * create one manually via {@link ImageBuilder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageBuilder.Builder#build()} is called immediately and its
         * result is passed to {@link #imageBuilder(ImageBuilder)}.
         * 
         * @param imageBuilder
         *        a consumer that will call methods on {@link ImageBuilder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageBuilder(ImageBuilder)
         */
        default Builder imageBuilder(Consumer<ImageBuilder.Builder> imageBuilder) {
            return imageBuilder(ImageBuilder.builder().applyMutation(imageBuilder).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private ImageBuilder imageBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImageBuilderResponse model) {
            super(model);
            imageBuilder(model.imageBuilder);
        }

        public final ImageBuilder.Builder getImageBuilder() {
            return imageBuilder != null ? imageBuilder.toBuilder() : null;
        }

        @Override
        public final Builder imageBuilder(ImageBuilder imageBuilder) {
            this.imageBuilder = imageBuilder;
            return this;
        }

        public final void setImageBuilder(ImageBuilder.BuilderImpl imageBuilder) {
            this.imageBuilder = imageBuilder != null ? imageBuilder.build() : null;
        }

        @Override
        public StartImageBuilderResponse build() {
            return new StartImageBuilderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
