/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StackAttribute {
    STORAGE_CONNECTORS("STORAGE_CONNECTORS"),
    STORAGE_CONNECTOR_HOMEFOLDERS("STORAGE_CONNECTOR_HOMEFOLDERS"),
    STORAGE_CONNECTOR_GOOGLE_DRIVE("STORAGE_CONNECTOR_GOOGLE_DRIVE"),
    STORAGE_CONNECTOR_ONE_DRIVE("STORAGE_CONNECTOR_ONE_DRIVE"),
    REDIRECT_URL("REDIRECT_URL"),
    FEEDBACK_URL("FEEDBACK_URL"),
    THEME_NAME("THEME_NAME"),
    USER_SETTINGS("USER_SETTINGS"),
    EMBED_HOST_DOMAINS("EMBED_HOST_DOMAINS"),
    IAM_ROLE_ARN("IAM_ROLE_ARN"),
    ACCESS_ENDPOINTS("ACCESS_ENDPOINTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StackAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StackAttribute.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackAttribute> knownValues() {
        return Stream.of(StackAttribute.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

