/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStackRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateStackRequest.Builder, UpdateStackRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateStackRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateStackRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateStackRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField
            .<List<StorageConnector>> builder(MarshallingType.LIST)
            .memberName("StorageConnectors")
            .getter(getter(UpdateStackRequest::storageConnectors))
            .setter(setter(Builder::storageConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageConnector> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageConnector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETE_STORAGE_CONNECTORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteStorageConnectors").getter(getter(UpdateStackRequest::deleteStorageConnectors))
            .setter(setter(Builder::deleteStorageConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteStorageConnectors").build())
            .build();

    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedirectURL").getter(getter(UpdateStackRequest::redirectURL)).setter(setter(Builder::redirectURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectURL").build()).build();

    private static final SdkField<String> FEEDBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackURL").getter(getter(UpdateStackRequest::feedbackURL)).setter(setter(Builder::feedbackURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackURL").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributesToDelete")
            .getter(getter(UpdateStackRequest::attributesToDeleteAsStrings))
            .setter(setter(Builder::attributesToDeleteWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField
            .<List<UserSetting>> builder(MarshallingType.LIST)
            .memberName("UserSettings")
            .getter(getter(UpdateStackRequest::userSettings))
            .setter(setter(Builder::userSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationSettings> APPLICATION_SETTINGS_FIELD = SdkField
            .<ApplicationSettings> builder(MarshallingType.SDK_POJO).memberName("ApplicationSettings")
            .getter(getter(UpdateStackRequest::applicationSettings)).setter(setter(Builder::applicationSettings))
            .constructor(ApplicationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build())
            .build();

    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField
            .<List<AccessEndpoint>> builder(MarshallingType.LIST)
            .memberName("AccessEndpoints")
            .getter(getter(UpdateStackRequest::accessEndpoints))
            .setter(setter(Builder::accessEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EMBED_HOST_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EmbedHostDomains")
            .getter(getter(UpdateStackRequest::embedHostDomains))
            .setter(setter(Builder::embedHostDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmbedHostDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, STORAGE_CONNECTORS_FIELD, DELETE_STORAGE_CONNECTORS_FIELD, REDIRECT_URL_FIELD,
            FEEDBACK_URL_FIELD, ATTRIBUTES_TO_DELETE_FIELD, USER_SETTINGS_FIELD, APPLICATION_SETTINGS_FIELD,
            ACCESS_ENDPOINTS_FIELD, EMBED_HOST_DOMAINS_FIELD));

    private final String displayName;

    private final String description;

    private final String name;

    private final List<StorageConnector> storageConnectors;

    private final Boolean deleteStorageConnectors;

    private final String redirectURL;

    private final String feedbackURL;

    private final List<String> attributesToDelete;

    private final List<UserSetting> userSettings;

    private final ApplicationSettings applicationSettings;

    private final List<AccessEndpoint> accessEndpoints;

    private final List<String> embedHostDomains;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.name = builder.name;
        this.storageConnectors = builder.storageConnectors;
        this.deleteStorageConnectors = builder.deleteStorageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.attributesToDelete = builder.attributesToDelete;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
        this.accessEndpoints = builder.accessEndpoints;
        this.embedHostDomains = builder.embedHostDomains;
    }

    /**
     * <p>
     * The stack name to display.
     * </p>
     * 
     * @return The stack name to display.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description to display.
     * </p>
     * 
     * @return The description to display.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the StorageConnectors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasStorageConnectors() {
        return storageConnectors != null && !(storageConnectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The storage connectors to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStorageConnectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The storage connectors to enable.
     */
    public final List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * Deletes the storage connectors currently enabled for the stack.
     * </p>
     * 
     * @return Deletes the storage connectors currently enabled for the stack.
     */
    public final Boolean deleteStorageConnectors() {
        return deleteStorageConnectors;
    }

    /**
     * <p>
     * The URL that users are redirected to after their streaming session ends.
     * </p>
     * 
     * @return The URL that users are redirected to after their streaming session ends.
     */
    public final String redirectURL() {
        return redirectURL;
    }

    /**
     * <p>
     * The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send
     * Feedback link is displayed.
     * </p>
     * 
     * @return The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no
     *         Send Feedback link is displayed.
     */
    public final String feedbackURL() {
        return feedbackURL;
    }

    /**
     * <p>
     * The stack attributes to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributesToDelete()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The stack attributes to delete.
     */
    public final List<StackAttribute> attributesToDelete() {
        return StackAttributesCopier.copyStringToEnum(attributesToDelete);
    }

    /**
     * Returns true if the AttributesToDelete property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttributesToDelete() {
        return attributesToDelete != null && !(attributesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stack attributes to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributesToDelete()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The stack attributes to delete.
     */
    public final List<String> attributesToDeleteAsStrings() {
        return attributesToDelete;
    }

    /**
     * Returns true if the UserSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserSettings() {
        return userSettings != null && !(userSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are
     * enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions that are enabled or disabled for users during their streaming sessions. By default, these
     *         actions are enabled.
     */
    public final List<UserSetting> userSettings() {
        return userSettings;
    }

    /**
     * <p>
     * The persistent application settings for users of a stack. When these settings are enabled, changes that users
     * make to applications and Windows settings are automatically saved after each session and applied to the next
     * session.
     * </p>
     * 
     * @return The persistent application settings for users of a stack. When these settings are enabled, changes that
     *         users make to applications and Windows settings are automatically saved after each session and applied to
     *         the next session.
     */
    public final ApplicationSettings applicationSettings() {
        return applicationSettings;
    }

    /**
     * Returns true if the AccessEndpoints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAccessEndpoints() {
        return accessEndpoints != null && !(accessEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0
     * only through the specified endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccessEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to
     *         AppStream 2.0 only through the specified endpoints.
     */
    public final List<AccessEndpoint> accessEndpoints() {
        return accessEndpoints;
    }

    /**
     * Returns true if the EmbedHostDomains property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEmbedHostDomains() {
        return embedHostDomains != null && !(embedHostDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
     * that you want to host embedded AppStream 2.0 streaming sessions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEmbedHostDomains()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
     *         domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    public final List<String> embedHostDomains() {
        return embedHostDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConnectors() ? storageConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deleteStorageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesToDelete() ? attributesToDeleteAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserSettings() ? userSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessEndpoints() ? accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEmbedHostDomains() ? embedHostDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && hasStorageConnectors() == other.hasStorageConnectors()
                && Objects.equals(storageConnectors(), other.storageConnectors())
                && Objects.equals(deleteStorageConnectors(), other.deleteStorageConnectors())
                && Objects.equals(redirectURL(), other.redirectURL()) && Objects.equals(feedbackURL(), other.feedbackURL())
                && hasAttributesToDelete() == other.hasAttributesToDelete()
                && Objects.equals(attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings())
                && hasUserSettings() == other.hasUserSettings() && Objects.equals(userSettings(), other.userSettings())
                && Objects.equals(applicationSettings(), other.applicationSettings())
                && hasAccessEndpoints() == other.hasAccessEndpoints()
                && Objects.equals(accessEndpoints(), other.accessEndpoints())
                && hasEmbedHostDomains() == other.hasEmbedHostDomains()
                && Objects.equals(embedHostDomains(), other.embedHostDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStackRequest").add("DisplayName", displayName()).add("Description", description())
                .add("Name", name()).add("StorageConnectors", hasStorageConnectors() ? storageConnectors() : null)
                .add("DeleteStorageConnectors", deleteStorageConnectors()).add("RedirectURL", redirectURL())
                .add("FeedbackURL", feedbackURL())
                .add("AttributesToDelete", hasAttributesToDelete() ? attributesToDeleteAsStrings() : null)
                .add("UserSettings", hasUserSettings() ? userSettings() : null).add("ApplicationSettings", applicationSettings())
                .add("AccessEndpoints", hasAccessEndpoints() ? accessEndpoints() : null)
                .add("EmbedHostDomains", hasEmbedHostDomains() ? embedHostDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StorageConnectors":
            return Optional.ofNullable(clazz.cast(storageConnectors()));
        case "DeleteStorageConnectors":
            return Optional.ofNullable(clazz.cast(deleteStorageConnectors()));
        case "RedirectURL":
            return Optional.ofNullable(clazz.cast(redirectURL()));
        case "FeedbackURL":
            return Optional.ofNullable(clazz.cast(feedbackURL()));
        case "AttributesToDelete":
            return Optional.ofNullable(clazz.cast(attributesToDeleteAsStrings()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        case "ApplicationSettings":
            return Optional.ofNullable(clazz.cast(applicationSettings()));
        case "AccessEndpoints":
            return Optional.ofNullable(clazz.cast(accessEndpoints()));
        case "EmbedHostDomains":
            return Optional.ofNullable(clazz.cast(embedHostDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStackRequest, T> g) {
        return obj -> g.apply((UpdateStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStackRequest> {
        /**
         * <p>
         * The stack name to display.
         * </p>
         * 
         * @param displayName
         *        The stack name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description to display.
         * </p>
         * 
         * @param description
         *        The description to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param name
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StorageConnector>.Builder} avoiding the
         * need to create one manually via {@link List<StorageConnector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageConnector>.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConnectors(List<StorageConnector>)}.
         * 
         * @param storageConnectors
         *        a consumer that will call methods on {@link List<StorageConnector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConnectors(List<StorageConnector>)
         */
        Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors);

        /**
         * <p>
         * Deletes the storage connectors currently enabled for the stack.
         * </p>
         * 
         * @param deleteStorageConnectors
         *        Deletes the storage connectors currently enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteStorageConnectors(Boolean deleteStorageConnectors);

        /**
         * <p>
         * The URL that users are redirected to after their streaming session ends.
         * </p>
         * 
         * @param redirectURL
         *        The URL that users are redirected to after their streaming session ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectURL(String redirectURL);

        /**
         * <p>
         * The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no
         * Send Feedback link is displayed.
         * </p>
         * 
         * @param feedbackURL
         *        The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified,
         *        no Send Feedback link is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackURL(String feedbackURL);

        /**
         * <p>
         * The stack attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The stack attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete);

        /**
         * <p>
         * The stack attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The stack attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(String... attributesToDelete);

        /**
         * <p>
         * The stack attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The stack attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(Collection<StackAttribute> attributesToDelete);

        /**
         * <p>
         * The stack attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The stack attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(StackAttribute... attributesToDelete);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default, these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(Collection<UserSetting> userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default, these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSetting... userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserSetting>.Builder} avoiding the need to
         * create one manually via {@link List<UserSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserSetting>.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(List<UserSetting>)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link List<UserSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(List<UserSetting>)
         */
        Builder userSettings(Consumer<UserSetting.Builder>... userSettings);

        /**
         * <p>
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users
         * make to applications and Windows settings are automatically saved after each session and applied to the next
         * session.
         * </p>
         * 
         * @param applicationSettings
         *        The persistent application settings for users of a stack. When these settings are enabled, changes
         *        that users make to applications and Windows settings are automatically saved after each session and
         *        applied to the next session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSettings(ApplicationSettings applicationSettings);

        /**
         * <p>
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users
         * make to applications and Windows settings are automatically saved after each session and applied to the next
         * session.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSettings.Builder} avoiding the need
         * to create one manually via {@link ApplicationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationSettings(ApplicationSettings)}.
         * 
         * @param applicationSettings
         *        a consumer that will call methods on {@link ApplicationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSettings(ApplicationSettings)
         */
        default Builder applicationSettings(Consumer<ApplicationSettings.Builder> applicationSettings) {
            return applicationSettings(ApplicationSettings.builder().applyMutation(applicationSettings).build());
        }

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream
         * 2.0 only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to
         *        AppStream 2.0 only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream
         * 2.0 only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to
         *        AppStream 2.0 only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(AccessEndpoint... accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream
         * 2.0 only through the specified endpoints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessEndpoint>.Builder} avoiding the need
         * to create one manually via {@link List<AccessEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #accessEndpoints(List<AccessEndpoint>)}.
         * 
         * @param accessEndpoints
         *        a consumer that will call methods on {@link List<AccessEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessEndpoints(List<AccessEndpoint>)
         */
        Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints);

        /**
         * <p>
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
         * that you want to host embedded AppStream 2.0 streaming sessions.
         * </p>
         * 
         * @param embedHostDomains
         *        The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
         *        domains that you want to host embedded AppStream 2.0 streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embedHostDomains(Collection<String> embedHostDomains);

        /**
         * <p>
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
         * that you want to host embedded AppStream 2.0 streaming sessions.
         * </p>
         * 
         * @param embedHostDomains
         *        The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
         *        domains that you want to host embedded AppStream 2.0 streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embedHostDomains(String... embedHostDomains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String displayName;

        private String description;

        private String name;

        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();

        private Boolean deleteStorageConnectors;

        private String redirectURL;

        private String feedbackURL;

        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();

        private ApplicationSettings applicationSettings;

        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> embedHostDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            super(model);
            displayName(model.displayName);
            description(model.description);
            name(model.name);
            storageConnectors(model.storageConnectors);
            deleteStorageConnectors(model.deleteStorageConnectors);
            redirectURL(model.redirectURL);
            feedbackURL(model.feedbackURL);
            attributesToDeleteWithStrings(model.attributesToDelete);
            userSettings(model.userSettings);
            applicationSettings(model.applicationSettings);
            accessEndpoints(model.accessEndpoints);
            embedHostDomains(model.embedHostDomains);
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<StorageConnector.Builder> getStorageConnectors() {
            List<StorageConnector.Builder> result = StorageConnectorListCopier.copyToBuilder(this.storageConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors) {
            storageConnectors(Stream.of(storageConnectors).map(c -> StorageConnector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final Boolean getDeleteStorageConnectors() {
            return deleteStorageConnectors;
        }

        @Override
        public final Builder deleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
            return this;
        }

        public final void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
        }

        public final String getRedirectURL() {
            return redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        public final String getFeedbackURL() {
            return feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        public final Collection<String> getAttributesToDelete() {
            if (attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesToDelete;
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String... attributesToDelete) {
            attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<StackAttribute> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(StackAttribute... attributesToDelete) {
            attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copy(attributesToDelete);
        }

        public final List<UserSetting.Builder> getUserSettings() {
            List<UserSetting.Builder> result = UserSettingListCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting... userSettings) {
            userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder>... userSettings) {
            userSettings(Stream.of(userSettings).map(c -> UserSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        public final ApplicationSettings.Builder getApplicationSettings() {
            return applicationSettings != null ? applicationSettings.toBuilder() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final void setApplicationSettings(ApplicationSettings.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint... accessEndpoints) {
            accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints) {
            accessEndpoints(Stream.of(accessEndpoints).map(c -> AccessEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        public final Collection<String> getEmbedHostDomains() {
            if (embedHostDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return embedHostDomains;
        }

        @Override
        public final Builder embedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embedHostDomains(String... embedHostDomains) {
            embedHostDomains(Arrays.asList(embedHostDomains));
            return this;
        }

        public final void setEmbedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
