/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImageBuilderState {
    PENDING("PENDING"),
    UPDATING_AGENT("UPDATING_AGENT"),
    RUNNING("RUNNING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    REBOOTING("REBOOTING"),
    SNAPSHOTTING("SNAPSHOTTING"),
    DELETING("DELETING"),
    FAILED("FAILED"),
    UPDATING("UPDATING"),
    PENDING_QUALIFICATION("PENDING_QUALIFICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ImageBuilderState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageBuilderState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ImageBuilderState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageBuilderState> knownValues() {
        return Stream.of(ImageBuilderState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

