/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError;
import software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionErrorsCopier;
import software.amazon.awssdk.services.appstream.model.UsageReportSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageReportSubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageReportSubscription> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(UsageReportSubscription.getter(UsageReportSubscription::s3BucketName)).setter(UsageReportSubscription.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(UsageReportSubscription.getter(UsageReportSubscription::scheduleAsString)).setter(UsageReportSubscription.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<Instant> LAST_GENERATED_REPORT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastGeneratedReportDate").getter(UsageReportSubscription.getter(UsageReportSubscription::lastGeneratedReportDate)).setter(UsageReportSubscription.setter(Builder::lastGeneratedReportDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastGeneratedReportDate").build()}).build();
    private static final SdkField<List<LastReportGenerationExecutionError>> SUBSCRIPTION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubscriptionErrors").getter(UsageReportSubscription.getter(UsageReportSubscription::subscriptionErrors)).setter(UsageReportSubscription.setter(Builder::subscriptionErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LastReportGenerationExecutionError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, SCHEDULE_FIELD, LAST_GENERATED_REPORT_DATE_FIELD, SUBSCRIPTION_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final String schedule;
    private final Instant lastGeneratedReportDate;
    private final List<LastReportGenerationExecutionError> subscriptionErrors;

    private UsageReportSubscription(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.schedule = builder.schedule;
        this.lastGeneratedReportDate = builder.lastGeneratedReportDate;
        this.subscriptionErrors = builder.subscriptionErrors;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final UsageReportSchedule schedule() {
        return UsageReportSchedule.fromValue(this.schedule);
    }

    public final String scheduleAsString() {
        return this.schedule;
    }

    public final Instant lastGeneratedReportDate() {
        return this.lastGeneratedReportDate;
    }

    public final boolean hasSubscriptionErrors() {
        return this.subscriptionErrors != null && !(this.subscriptionErrors instanceof SdkAutoConstructList);
    }

    public final List<LastReportGenerationExecutionError> subscriptionErrors() {
        return this.subscriptionErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastGeneratedReportDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptionErrors() ? this.subscriptionErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageReportSubscription)) {
            return false;
        }
        UsageReportSubscription other = (UsageReportSubscription)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.scheduleAsString(), other.scheduleAsString()) && Objects.equals(this.lastGeneratedReportDate(), other.lastGeneratedReportDate()) && this.hasSubscriptionErrors() == other.hasSubscriptionErrors() && Objects.equals(this.subscriptionErrors(), other.subscriptionErrors());
    }

    public final String toString() {
        return ToString.builder((String)"UsageReportSubscription").add("S3BucketName", (Object)this.s3BucketName()).add("Schedule", (Object)this.scheduleAsString()).add("LastGeneratedReportDate", (Object)this.lastGeneratedReportDate()).add("SubscriptionErrors", this.hasSubscriptionErrors() ? this.subscriptionErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.scheduleAsString()));
            }
            case "LastGeneratedReportDate": {
                return Optional.ofNullable(clazz.cast(this.lastGeneratedReportDate()));
            }
            case "SubscriptionErrors": {
                return Optional.ofNullable(clazz.cast(this.subscriptionErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageReportSubscription, T> g) {
        return obj -> g.apply((UsageReportSubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String schedule;
        private Instant lastGeneratedReportDate;
        private List<LastReportGenerationExecutionError> subscriptionErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageReportSubscription model) {
            this.s3BucketName(model.s3BucketName);
            this.schedule(model.schedule);
            this.lastGeneratedReportDate(model.lastGeneratedReportDate);
            this.subscriptionErrors(model.subscriptionErrors);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public final Builder schedule(UsageReportSchedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Instant getLastGeneratedReportDate() {
            return this.lastGeneratedReportDate;
        }

        @Override
        public final Builder lastGeneratedReportDate(Instant lastGeneratedReportDate) {
            this.lastGeneratedReportDate = lastGeneratedReportDate;
            return this;
        }

        public final void setLastGeneratedReportDate(Instant lastGeneratedReportDate) {
            this.lastGeneratedReportDate = lastGeneratedReportDate;
        }

        public final Collection<LastReportGenerationExecutionError.Builder> getSubscriptionErrors() {
            if (this.subscriptionErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subscriptionErrors != null ? (Collection)this.subscriptionErrors.stream().map(LastReportGenerationExecutionError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptionErrors(Collection<LastReportGenerationExecutionError> subscriptionErrors) {
            this.subscriptionErrors = LastReportGenerationExecutionErrorsCopier.copy(subscriptionErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionErrors(LastReportGenerationExecutionError ... subscriptionErrors) {
            this.subscriptionErrors(Arrays.asList(subscriptionErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionErrors(Consumer<LastReportGenerationExecutionError.Builder> ... subscriptionErrors) {
            this.subscriptionErrors(Stream.of(subscriptionErrors).map(c -> (LastReportGenerationExecutionError)((LastReportGenerationExecutionError.Builder)LastReportGenerationExecutionError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptionErrors(Collection<LastReportGenerationExecutionError.BuilderImpl> subscriptionErrors) {
            this.subscriptionErrors = LastReportGenerationExecutionErrorsCopier.copyFromBuilder(subscriptionErrors);
        }

        public UsageReportSubscription build() {
            return new UsageReportSubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageReportSubscription> {
        public Builder s3BucketName(String var1);

        public Builder schedule(String var1);

        public Builder schedule(UsageReportSchedule var1);

        public Builder lastGeneratedReportDate(Instant var1);

        public Builder subscriptionErrors(Collection<LastReportGenerationExecutionError> var1);

        public Builder subscriptionErrors(LastReportGenerationExecutionError ... var1);

        public Builder subscriptionErrors(Consumer<LastReportGenerationExecutionError.Builder> ... var1);
    }
}

