/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information about the usage report subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageReportSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageReportSubscription.Builder, UsageReportSubscription> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(UsageReportSubscription::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(UsageReportSubscription::scheduleAsString)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<Instant> LAST_GENERATED_REPORT_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastGeneratedReportDate").getter(getter(UsageReportSubscription::lastGeneratedReportDate))
            .setter(setter(Builder::lastGeneratedReportDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastGeneratedReportDate").build())
            .build();

    private static final SdkField<List<LastReportGenerationExecutionError>> SUBSCRIPTION_ERRORS_FIELD = SdkField
            .<List<LastReportGenerationExecutionError>> builder(MarshallingType.LIST)
            .memberName("SubscriptionErrors")
            .getter(getter(UsageReportSubscription::subscriptionErrors))
            .setter(setter(Builder::subscriptionErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LastReportGenerationExecutionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(LastReportGenerationExecutionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            SCHEDULE_FIELD, LAST_GENERATED_REPORT_DATE_FIELD, SUBSCRIPTION_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3BucketName;

    private final String schedule;

    private final Instant lastGeneratedReportDate;

    private final List<LastReportGenerationExecutionError> subscriptionErrors;

    private UsageReportSubscription(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.schedule = builder.schedule;
        this.lastGeneratedReportDate = builder.lastGeneratedReportDate;
        this.subscriptionErrors = builder.subscriptionErrors;
    }

    /**
     * <p>
     * The Amazon S3 bucket where generated reports are stored.
     * </p>
     * <p>
     * If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration, AppStream
     * 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and Region. When you
     * enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage reports. If you
     * haven't already enabled on-instance session scripts, when you enable usage reports, AppStream 2.0 creates a new
     * S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 bucket where generated reports are stored.</p>
     *         <p>
     *         If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration,
     *         AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and
     *         Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your
     *         usage reports. If you haven't already enabled on-instance session scripts, when you enable usage reports,
     *         AppStream 2.0 creates a new S3 bucket.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The schedule for generating usage reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link UsageReportSchedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleAsString}.
     * </p>
     * 
     * @return The schedule for generating usage reports.
     * @see UsageReportSchedule
     */
    public final UsageReportSchedule schedule() {
        return UsageReportSchedule.fromValue(schedule);
    }

    /**
     * <p>
     * The schedule for generating usage reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link UsageReportSchedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleAsString}.
     * </p>
     * 
     * @return The schedule for generating usage reports.
     * @see UsageReportSchedule
     */
    public final String scheduleAsString() {
        return schedule;
    }

    /**
     * <p>
     * The time when the last usage report was generated.
     * </p>
     * 
     * @return The time when the last usage report was generated.
     */
    public final Instant lastGeneratedReportDate() {
        return lastGeneratedReportDate;
    }

    /**
     * Returns true if the SubscriptionErrors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSubscriptionErrors() {
        return subscriptionErrors != null && !(subscriptionErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors that were returned if usage reports couldn't be generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscriptionErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The errors that were returned if usage reports couldn't be generated.
     */
    public final List<LastReportGenerationExecutionError> subscriptionErrors() {
        return subscriptionErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastGeneratedReportDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptionErrors() ? subscriptionErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageReportSubscription)) {
            return false;
        }
        UsageReportSubscription other = (UsageReportSubscription) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(scheduleAsString(), other.scheduleAsString())
                && Objects.equals(lastGeneratedReportDate(), other.lastGeneratedReportDate())
                && hasSubscriptionErrors() == other.hasSubscriptionErrors()
                && Objects.equals(subscriptionErrors(), other.subscriptionErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageReportSubscription").add("S3BucketName", s3BucketName())
                .add("Schedule", scheduleAsString()).add("LastGeneratedReportDate", lastGeneratedReportDate())
                .add("SubscriptionErrors", hasSubscriptionErrors() ? subscriptionErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(scheduleAsString()));
        case "LastGeneratedReportDate":
            return Optional.ofNullable(clazz.cast(lastGeneratedReportDate()));
        case "SubscriptionErrors":
            return Optional.ofNullable(clazz.cast(subscriptionErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageReportSubscription, T> g) {
        return obj -> g.apply((UsageReportSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageReportSubscription> {
        /**
         * <p>
         * The Amazon S3 bucket where generated reports are stored.
         * </p>
         * <p>
         * If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration,
         * AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and
         * Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage
         * reports. If you haven't already enabled on-instance session scripts, when you enable usage reports, AppStream
         * 2.0 creates a new S3 bucket.
         * </p>
         * 
         * @param s3BucketName
         *        The Amazon S3 bucket where generated reports are stored.</p>
         *        <p>
         *        If you enabled on-instance session scripts and Amazon S3 logging for your session script
         *        configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to
         *        your account and Region. When you enable usage reporting in this case, AppStream 2.0 uses the same
         *        bucket to store your usage reports. If you haven't already enabled on-instance session scripts, when
         *        you enable usage reports, AppStream 2.0 creates a new S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The schedule for generating usage reports.
         * </p>
         * 
         * @param schedule
         *        The schedule for generating usage reports.
         * @see UsageReportSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageReportSchedule
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The schedule for generating usage reports.
         * </p>
         * 
         * @param schedule
         *        The schedule for generating usage reports.
         * @see UsageReportSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageReportSchedule
         */
        Builder schedule(UsageReportSchedule schedule);

        /**
         * <p>
         * The time when the last usage report was generated.
         * </p>
         * 
         * @param lastGeneratedReportDate
         *        The time when the last usage report was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastGeneratedReportDate(Instant lastGeneratedReportDate);

        /**
         * <p>
         * The errors that were returned if usage reports couldn't be generated.
         * </p>
         * 
         * @param subscriptionErrors
         *        The errors that were returned if usage reports couldn't be generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionErrors(Collection<LastReportGenerationExecutionError> subscriptionErrors);

        /**
         * <p>
         * The errors that were returned if usage reports couldn't be generated.
         * </p>
         * 
         * @param subscriptionErrors
         *        The errors that were returned if usage reports couldn't be generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionErrors(LastReportGenerationExecutionError... subscriptionErrors);

        /**
         * <p>
         * The errors that were returned if usage reports couldn't be generated.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LastReportGenerationExecutionError>.Builder} avoiding the need to create one manually via {@link List
         * <LastReportGenerationExecutionError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LastReportGenerationExecutionError>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #subscriptionErrors(List<LastReportGenerationExecutionError>)}.
         * 
         * @param subscriptionErrors
         *        a consumer that will call methods on {@link List<LastReportGenerationExecutionError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptionErrors(List<LastReportGenerationExecutionError>)
         */
        Builder subscriptionErrors(Consumer<LastReportGenerationExecutionError.Builder>... subscriptionErrors);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketName;

        private String schedule;

        private Instant lastGeneratedReportDate;

        private List<LastReportGenerationExecutionError> subscriptionErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageReportSubscription model) {
            s3BucketName(model.s3BucketName);
            schedule(model.schedule);
            lastGeneratedReportDate(model.lastGeneratedReportDate);
            subscriptionErrors(model.subscriptionErrors);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        @Transient
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        @Transient
        public final Builder schedule(UsageReportSchedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        public final Instant getLastGeneratedReportDate() {
            return lastGeneratedReportDate;
        }

        public final void setLastGeneratedReportDate(Instant lastGeneratedReportDate) {
            this.lastGeneratedReportDate = lastGeneratedReportDate;
        }

        @Override
        @Transient
        public final Builder lastGeneratedReportDate(Instant lastGeneratedReportDate) {
            this.lastGeneratedReportDate = lastGeneratedReportDate;
            return this;
        }

        public final List<LastReportGenerationExecutionError.Builder> getSubscriptionErrors() {
            List<LastReportGenerationExecutionError.Builder> result = LastReportGenerationExecutionErrorsCopier
                    .copyToBuilder(this.subscriptionErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptionErrors(Collection<LastReportGenerationExecutionError.BuilderImpl> subscriptionErrors) {
            this.subscriptionErrors = LastReportGenerationExecutionErrorsCopier.copyFromBuilder(subscriptionErrors);
        }

        @Override
        @Transient
        public final Builder subscriptionErrors(Collection<LastReportGenerationExecutionError> subscriptionErrors) {
            this.subscriptionErrors = LastReportGenerationExecutionErrorsCopier.copy(subscriptionErrors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscriptionErrors(LastReportGenerationExecutionError... subscriptionErrors) {
            subscriptionErrors(Arrays.asList(subscriptionErrors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscriptionErrors(Consumer<LastReportGenerationExecutionError.Builder>... subscriptionErrors) {
            subscriptionErrors(Stream.of(subscriptionErrors)
                    .map(c -> LastReportGenerationExecutionError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UsageReportSubscription build() {
            return new UsageReportSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
