/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppBlockResponse extends AppStreamResponse implements
        ToCopyableBuilder<CreateAppBlockResponse.Builder, CreateAppBlockResponse> {
    private static final SdkField<AppBlock> APP_BLOCK_FIELD = SdkField.<AppBlock> builder(MarshallingType.SDK_POJO)
            .memberName("AppBlock").getter(getter(CreateAppBlockResponse::appBlock)).setter(setter(Builder::appBlock))
            .constructor(AppBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCK_FIELD));

    private final AppBlock appBlock;

    private CreateAppBlockResponse(BuilderImpl builder) {
        super(builder);
        this.appBlock = builder.appBlock;
    }

    /**
     * <p>
     * The app block.
     * </p>
     * 
     * @return The app block.
     */
    public final AppBlock appBlock() {
        return appBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppBlockResponse)) {
            return false;
        }
        CreateAppBlockResponse other = (CreateAppBlockResponse) obj;
        return Objects.equals(appBlock(), other.appBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppBlockResponse").add("AppBlock", appBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppBlock":
            return Optional.ofNullable(clazz.cast(appBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppBlockResponse, T> g) {
        return obj -> g.apply((CreateAppBlockResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppBlockResponse> {
        /**
         * <p>
         * The app block.
         * </p>
         * 
         * @param appBlock
         *        The app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlock(AppBlock appBlock);

        /**
         * <p>
         * The app block.
         * </p>
         * This is a convenience that creates an instance of the {@link AppBlock.Builder} avoiding the need to create
         * one manually via {@link AppBlock#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppBlock.Builder#build()} is called immediately and its result is
         * passed to {@link #appBlock(AppBlock)}.
         * 
         * @param appBlock
         *        a consumer that will call methods on {@link AppBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appBlock(AppBlock)
         */
        default Builder appBlock(Consumer<AppBlock.Builder> appBlock) {
            return appBlock(AppBlock.builder().applyMutation(appBlock).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private AppBlock appBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppBlockResponse model) {
            super(model);
            appBlock(model.appBlock);
        }

        public final AppBlock.Builder getAppBlock() {
            return appBlock != null ? appBlock.toBuilder() : null;
        }

        public final void setAppBlock(AppBlock.BuilderImpl appBlock) {
            this.appBlock = appBlock != null ? appBlock.build() : null;
        }

        @Override
        @Transient
        public final Builder appBlock(AppBlock appBlock) {
            this.appBlock = appBlock;
            return this;
        }

        @Override
        public CreateAppBlockResponse build() {
            return new CreateAppBlockResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
