/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an app block.
 * </p>
 * <p>
 * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3 bucket.
 * It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard disk includes
 * the application binaries and other files necessary to launch your applications. Multiple applications can be assigned
 * to a single app block.
 * </p>
 * <p>
 * This is only supported for Elastic fleets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppBlock implements SdkPojo, Serializable, ToCopyableBuilder<AppBlock.Builder, AppBlock> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AppBlock::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AppBlock::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AppBlock::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(AppBlock::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<S3Location> SOURCE_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("SourceS3Location").getter(getter(AppBlock::sourceS3Location)).setter(setter(Builder::sourceS3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Location").build()).build();

    private static final SdkField<ScriptDetails> SETUP_SCRIPT_DETAILS_FIELD = SdkField
            .<ScriptDetails> builder(MarshallingType.SDK_POJO).memberName("SetupScriptDetails")
            .getter(getter(AppBlock::setupScriptDetails)).setter(setter(Builder::setupScriptDetails))
            .constructor(ScriptDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupScriptDetails").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(AppBlock::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, SOURCE_S3_LOCATION_FIELD, SETUP_SCRIPT_DETAILS_FIELD, CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String description;

    private final String displayName;

    private final S3Location sourceS3Location;

    private final ScriptDetails setupScriptDetails;

    private final Instant createdTime;

    private AppBlock(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.sourceS3Location = builder.sourceS3Location;
        this.setupScriptDetails = builder.setupScriptDetails;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The name of the app block.
     * </p>
     * 
     * @return The name of the app block.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the app block.
     * </p>
     * 
     * @return The ARN of the app block.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the app block.
     * </p>
     * 
     * @return The description of the app block.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the app block.
     * </p>
     * 
     * @return The display name of the app block.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The source S3 location of the app block.
     * </p>
     * 
     * @return The source S3 location of the app block.
     */
    public final S3Location sourceS3Location() {
        return sourceS3Location;
    }

    /**
     * <p>
     * The setup script details of the app block.
     * </p>
     * 
     * @return The setup script details of the app block.
     */
    public final ScriptDetails setupScriptDetails() {
        return setupScriptDetails;
    }

    /**
     * <p>
     * The created time of the app block.
     * </p>
     * 
     * @return The created time of the app block.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(setupScriptDetails());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppBlock)) {
            return false;
        }
        AppBlock other = (AppBlock) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(sourceS3Location(), other.sourceS3Location())
                && Objects.equals(setupScriptDetails(), other.setupScriptDetails())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppBlock").add("Name", name()).add("Arn", arn()).add("Description", description())
                .add("DisplayName", displayName()).add("SourceS3Location", sourceS3Location())
                .add("SetupScriptDetails", setupScriptDetails()).add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "SourceS3Location":
            return Optional.ofNullable(clazz.cast(sourceS3Location()));
        case "SetupScriptDetails":
            return Optional.ofNullable(clazz.cast(setupScriptDetails()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppBlock, T> g) {
        return obj -> g.apply((AppBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppBlock> {
        /**
         * <p>
         * The name of the app block.
         * </p>
         * 
         * @param name
         *        The name of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the app block.
         * </p>
         * 
         * @param arn
         *        The ARN of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the app block.
         * </p>
         * 
         * @param description
         *        The description of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the app block.
         * </p>
         * 
         * @param displayName
         *        The display name of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The source S3 location of the app block.
         * </p>
         * 
         * @param sourceS3Location
         *        The source S3 location of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Location(S3Location sourceS3Location);

        /**
         * <p>
         * The source S3 location of the app block.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceS3Location(S3Location)}.
         * 
         * @param sourceS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Location(S3Location)
         */
        default Builder sourceS3Location(Consumer<S3Location.Builder> sourceS3Location) {
            return sourceS3Location(S3Location.builder().applyMutation(sourceS3Location).build());
        }

        /**
         * <p>
         * The setup script details of the app block.
         * </p>
         * 
         * @param setupScriptDetails
         *        The setup script details of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupScriptDetails(ScriptDetails setupScriptDetails);

        /**
         * <p>
         * The setup script details of the app block.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScriptDetails.Builder} avoiding the need
         * to create one manually via {@link ScriptDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScriptDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #setupScriptDetails(ScriptDetails)}.
         * 
         * @param setupScriptDetails
         *        a consumer that will call methods on {@link ScriptDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setupScriptDetails(ScriptDetails)
         */
        default Builder setupScriptDetails(Consumer<ScriptDetails.Builder> setupScriptDetails) {
            return setupScriptDetails(ScriptDetails.builder().applyMutation(setupScriptDetails).build());
        }

        /**
         * <p>
         * The created time of the app block.
         * </p>
         * 
         * @param createdTime
         *        The created time of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String description;

        private String displayName;

        private S3Location sourceS3Location;

        private ScriptDetails setupScriptDetails;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AppBlock model) {
            name(model.name);
            arn(model.arn);
            description(model.description);
            displayName(model.displayName);
            sourceS3Location(model.sourceS3Location);
            setupScriptDetails(model.setupScriptDetails);
            createdTime(model.createdTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final S3Location.Builder getSourceS3Location() {
            return sourceS3Location != null ? sourceS3Location.toBuilder() : null;
        }

        public final void setSourceS3Location(S3Location.BuilderImpl sourceS3Location) {
            this.sourceS3Location = sourceS3Location != null ? sourceS3Location.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceS3Location(S3Location sourceS3Location) {
            this.sourceS3Location = sourceS3Location;
            return this;
        }

        public final ScriptDetails.Builder getSetupScriptDetails() {
            return setupScriptDetails != null ? setupScriptDetails.toBuilder() : null;
        }

        public final void setSetupScriptDetails(ScriptDetails.BuilderImpl setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails != null ? setupScriptDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder setupScriptDetails(ScriptDetails setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public AppBlock build() {
            return new AppBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
