/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackResponse extends AppStreamResponse implements
        ToCopyableBuilder<CreateStackResponse.Builder, CreateStackResponse> {
    private static final SdkField<Stack> STACK_FIELD = SdkField.<Stack> builder(MarshallingType.SDK_POJO).memberName("Stack")
            .getter(getter(CreateStackResponse::stack)).setter(setter(Builder::stack)).constructor(Stack::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stack").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_FIELD));

    private final Stack stack;

    private CreateStackResponse(BuilderImpl builder) {
        super(builder);
        this.stack = builder.stack;
    }

    /**
     * <p>
     * Information about the stack.
     * </p>
     * 
     * @return Information about the stack.
     */
    public final Stack stack() {
        return stack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stack());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackResponse)) {
            return false;
        }
        CreateStackResponse other = (CreateStackResponse) obj;
        return Objects.equals(stack(), other.stack());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStackResponse").add("Stack", stack()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stack":
            return Optional.ofNullable(clazz.cast(stack()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStackResponse, T> g) {
        return obj -> g.apply((CreateStackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStackResponse> {
        /**
         * <p>
         * Information about the stack.
         * </p>
         * 
         * @param stack
         *        Information about the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stack(Stack stack);

        /**
         * <p>
         * Information about the stack.
         * </p>
         * This is a convenience method that creates an instance of the {@link Stack.Builder} avoiding the need to
         * create one manually via {@link Stack#builder()}.
         *
         * When the {@link Consumer} completes, {@link Stack.Builder#build()} is called immediately and its result is
         * passed to {@link #stack(Stack)}.
         * 
         * @param stack
         *        a consumer that will call methods on {@link Stack.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stack(Stack)
         */
        default Builder stack(Consumer<Stack.Builder> stack) {
            return stack(Stack.builder().applyMutation(stack).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private Stack stack;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackResponse model) {
            super(model);
            stack(model.stack);
        }

        public final Stack.Builder getStack() {
            return stack != null ? stack.toBuilder() : null;
        }

        public final void setStack(Stack.BuilderImpl stack) {
            this.stack = stack != null ? stack.build() : null;
        }

        @Override
        @Transient
        public final Builder stack(Stack stack) {
            this.stack = stack;
            return this;
        }

        @Override
        public CreateStackResponse build() {
            return new CreateStackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
