/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageBuildersResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeImageBuildersResponse.Builder, DescribeImageBuildersResponse> {
    private static final SdkField<List<ImageBuilder>> IMAGE_BUILDERS_FIELD = SdkField
            .<List<ImageBuilder>> builder(MarshallingType.LIST)
            .memberName("ImageBuilders")
            .getter(getter(DescribeImageBuildersResponse::imageBuilders))
            .setter(setter(Builder::imageBuilders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageBuilder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageBuilder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeImageBuildersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_BUILDERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImageBuilder> imageBuilders;

    private final String nextToken;

    private DescribeImageBuildersResponse(BuilderImpl builder) {
        super(builder);
        this.imageBuilders = builder.imageBuilders;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageBuilders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageBuilders() {
        return imageBuilders != null && !(imageBuilders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the image builders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageBuilders} method.
     * </p>
     * 
     * @return Information about the image builders.
     */
    public final List<ImageBuilder> imageBuilders() {
        return imageBuilders;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageBuilders() ? imageBuilders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageBuildersResponse)) {
            return false;
        }
        DescribeImageBuildersResponse other = (DescribeImageBuildersResponse) obj;
        return hasImageBuilders() == other.hasImageBuilders() && Objects.equals(imageBuilders(), other.imageBuilders())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageBuildersResponse")
                .add("ImageBuilders", hasImageBuilders() ? imageBuilders() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageBuilders":
            return Optional.ofNullable(clazz.cast(imageBuilders()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageBuildersResponse, T> g) {
        return obj -> g.apply((DescribeImageBuildersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageBuildersResponse> {
        /**
         * <p>
         * Information about the image builders.
         * </p>
         * 
         * @param imageBuilders
         *        Information about the image builders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilders(Collection<ImageBuilder> imageBuilders);

        /**
         * <p>
         * Information about the image builders.
         * </p>
         * 
         * @param imageBuilders
         *        Information about the image builders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilders(ImageBuilder... imageBuilders);

        /**
         * <p>
         * Information about the image builders.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ImageBuilder>.Builder} avoiding the
         * need to create one manually via {@link List<ImageBuilder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageBuilder>.Builder#build()} is called immediately and its
         * result is passed to {@link #imageBuilders(List<ImageBuilder>)}.
         * 
         * @param imageBuilders
         *        a consumer that will call methods on {@link List<ImageBuilder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageBuilders(List<ImageBuilder>)
         */
        Builder imageBuilders(Consumer<ImageBuilder.Builder>... imageBuilders);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<ImageBuilder> imageBuilders = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageBuildersResponse model) {
            super(model);
            imageBuilders(model.imageBuilders);
            nextToken(model.nextToken);
        }

        public final List<ImageBuilder.Builder> getImageBuilders() {
            List<ImageBuilder.Builder> result = ImageBuilderListCopier.copyToBuilder(this.imageBuilders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageBuilders(Collection<ImageBuilder.BuilderImpl> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copyFromBuilder(imageBuilders);
        }

        @Override
        @Transient
        public final Builder imageBuilders(Collection<ImageBuilder> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copy(imageBuilders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageBuilders(ImageBuilder... imageBuilders) {
            imageBuilders(Arrays.asList(imageBuilders));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageBuilders(Consumer<ImageBuilder.Builder>... imageBuilders) {
            imageBuilders(Stream.of(imageBuilders).map(c -> ImageBuilder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImageBuildersResponse build() {
            return new DescribeImageBuildersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
