/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUsageReportSubscriptionsResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeUsageReportSubscriptionsResponse.Builder, DescribeUsageReportSubscriptionsResponse> {
    private static final SdkField<List<UsageReportSubscription>> USAGE_REPORT_SUBSCRIPTIONS_FIELD = SdkField
            .<List<UsageReportSubscription>> builder(MarshallingType.LIST)
            .memberName("UsageReportSubscriptions")
            .getter(getter(DescribeUsageReportSubscriptionsResponse::usageReportSubscriptions))
            .setter(setter(Builder::usageReportSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageReportSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageReportSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageReportSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeUsageReportSubscriptionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USAGE_REPORT_SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<UsageReportSubscription> usageReportSubscriptions;

    private final String nextToken;

    private DescribeUsageReportSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.usageReportSubscriptions = builder.usageReportSubscriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageReportSubscriptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUsageReportSubscriptions() {
        return usageReportSubscriptions != null && !(usageReportSubscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the usage report subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageReportSubscriptions} method.
     * </p>
     * 
     * @return Information about the usage report subscription.
     */
    public final List<UsageReportSubscription> usageReportSubscriptions() {
        return usageReportSubscriptions;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageReportSubscriptions() ? usageReportSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsageReportSubscriptionsResponse)) {
            return false;
        }
        DescribeUsageReportSubscriptionsResponse other = (DescribeUsageReportSubscriptionsResponse) obj;
        return hasUsageReportSubscriptions() == other.hasUsageReportSubscriptions()
                && Objects.equals(usageReportSubscriptions(), other.usageReportSubscriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUsageReportSubscriptionsResponse")
                .add("UsageReportSubscriptions", hasUsageReportSubscriptions() ? usageReportSubscriptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageReportSubscriptions":
            return Optional.ofNullable(clazz.cast(usageReportSubscriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUsageReportSubscriptionsResponse, T> g) {
        return obj -> g.apply((DescribeUsageReportSubscriptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUsageReportSubscriptionsResponse> {
        /**
         * <p>
         * Information about the usage report subscription.
         * </p>
         * 
         * @param usageReportSubscriptions
         *        Information about the usage report subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageReportSubscriptions(Collection<UsageReportSubscription> usageReportSubscriptions);

        /**
         * <p>
         * Information about the usage report subscription.
         * </p>
         * 
         * @param usageReportSubscriptions
         *        Information about the usage report subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageReportSubscriptions(UsageReportSubscription... usageReportSubscriptions);

        /**
         * <p>
         * Information about the usage report subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UsageReportSubscription>.Builder}
         * avoiding the need to create one manually via {@link List<UsageReportSubscription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageReportSubscription>.Builder#build()} is called
         * immediately and its result is passed to {@link #usageReportSubscriptions(List<UsageReportSubscription>)}.
         * 
         * @param usageReportSubscriptions
         *        a consumer that will call methods on {@link List<UsageReportSubscription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageReportSubscriptions(List<UsageReportSubscription>)
         */
        Builder usageReportSubscriptions(Consumer<UsageReportSubscription.Builder>... usageReportSubscriptions);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<UsageReportSubscription> usageReportSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsageReportSubscriptionsResponse model) {
            super(model);
            usageReportSubscriptions(model.usageReportSubscriptions);
            nextToken(model.nextToken);
        }

        public final List<UsageReportSubscription.Builder> getUsageReportSubscriptions() {
            List<UsageReportSubscription.Builder> result = UsageReportSubscriptionListCopier
                    .copyToBuilder(this.usageReportSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageReportSubscriptions(Collection<UsageReportSubscription.BuilderImpl> usageReportSubscriptions) {
            this.usageReportSubscriptions = UsageReportSubscriptionListCopier.copyFromBuilder(usageReportSubscriptions);
        }

        @Override
        @Transient
        public final Builder usageReportSubscriptions(Collection<UsageReportSubscription> usageReportSubscriptions) {
            this.usageReportSubscriptions = UsageReportSubscriptionListCopier.copy(usageReportSubscriptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usageReportSubscriptions(UsageReportSubscription... usageReportSubscriptions) {
            usageReportSubscriptions(Arrays.asList(usageReportSubscriptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usageReportSubscriptions(Consumer<UsageReportSubscription.Builder>... usageReportSubscriptions) {
            usageReportSubscriptions(Stream.of(usageReportSubscriptions)
                    .map(c -> UsageReportSubscription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeUsageReportSubscriptionsResponse build() {
            return new DescribeUsageReportSubscriptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
