/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEntitlementRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateEntitlementRequest.Builder, UpdateEntitlementRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateEntitlementRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(UpdateEntitlementRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateEntitlementRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> APP_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppVisibility").getter(getter(UpdateEntitlementRequest::appVisibilityAsString))
            .setter(setter(Builder::appVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVisibility").build()).build();

    private static final SdkField<List<EntitlementAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<EntitlementAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(UpdateEntitlementRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitlementAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitlementAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STACK_NAME_FIELD,
            DESCRIPTION_FIELD, APP_VISIBILITY_FIELD, ATTRIBUTES_FIELD));

    private final String name;

    private final String stackName;

    private final String description;

    private final String appVisibility;

    private final List<EntitlementAttribute> attributes;

    private UpdateEntitlementRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stackName = builder.stackName;
        this.description = builder.description;
        this.appVisibility = builder.appVisibility;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The name of the entitlement.
     * </p>
     * 
     * @return The name of the entitlement.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the stack with which the entitlement is associated.
     * </p>
     * 
     * @return The name of the stack with which the entitlement is associated.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The description of the entitlement.
     * </p>
     * 
     * @return The description of the entitlement.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether all or only selected apps are entitled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appVisibility}
     * will return {@link AppVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appVisibilityAsString}.
     * </p>
     * 
     * @return Specifies whether all or only selected apps are entitled.
     * @see AppVisibility
     */
    public final AppVisibility appVisibility() {
        return AppVisibility.fromValue(appVisibility);
    }

    /**
     * <p>
     * Specifies whether all or only selected apps are entitled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appVisibility}
     * will return {@link AppVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appVisibilityAsString}.
     * </p>
     * 
     * @return Specifies whether all or only selected apps are entitled.
     * @see AppVisibility
     */
    public final String appVisibilityAsString() {
        return appVisibility;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the entitlement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attributes of the entitlement.
     */
    public final List<EntitlementAttribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(appVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEntitlementRequest)) {
            return false;
        }
        UpdateEntitlementRequest other = (UpdateEntitlementRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(description(), other.description())
                && Objects.equals(appVisibilityAsString(), other.appVisibilityAsString())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEntitlementRequest").add("Name", name()).add("StackName", stackName())
                .add("Description", description()).add("AppVisibility", appVisibilityAsString())
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AppVisibility":
            return Optional.ofNullable(clazz.cast(appVisibilityAsString()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEntitlementRequest, T> g) {
        return obj -> g.apply((UpdateEntitlementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEntitlementRequest> {
        /**
         * <p>
         * The name of the entitlement.
         * </p>
         * 
         * @param name
         *        The name of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the stack with which the entitlement is associated.
         * </p>
         * 
         * @param stackName
         *        The name of the stack with which the entitlement is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The description of the entitlement.
         * </p>
         * 
         * @param description
         *        The description of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether all or only selected apps are entitled.
         * </p>
         * 
         * @param appVisibility
         *        Specifies whether all or only selected apps are entitled.
         * @see AppVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppVisibility
         */
        Builder appVisibility(String appVisibility);

        /**
         * <p>
         * Specifies whether all or only selected apps are entitled.
         * </p>
         * 
         * @param appVisibility
         *        Specifies whether all or only selected apps are entitled.
         * @see AppVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppVisibility
         */
        Builder appVisibility(AppVisibility appVisibility);

        /**
         * <p>
         * The attributes of the entitlement.
         * </p>
         * 
         * @param attributes
         *        The attributes of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<EntitlementAttribute> attributes);

        /**
         * <p>
         * The attributes of the entitlement.
         * </p>
         * 
         * @param attributes
         *        The attributes of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(EntitlementAttribute... attributes);

        /**
         * <p>
         * The attributes of the entitlement.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EntitlementAttribute>.Builder}
         * avoiding the need to create one manually via {@link List<EntitlementAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntitlementAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributes(List<EntitlementAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<EntitlementAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<EntitlementAttribute>)
         */
        Builder attributes(Consumer<EntitlementAttribute.Builder>... attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String stackName;

        private String description;

        private String appVisibility;

        private List<EntitlementAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEntitlementRequest model) {
            super(model);
            name(model.name);
            stackName(model.stackName);
            description(model.description);
            appVisibility(model.appVisibility);
            attributes(model.attributes);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAppVisibility() {
            return appVisibility;
        }

        public final void setAppVisibility(String appVisibility) {
            this.appVisibility = appVisibility;
        }

        @Override
        @Transient
        public final Builder appVisibility(String appVisibility) {
            this.appVisibility = appVisibility;
            return this;
        }

        @Override
        @Transient
        public final Builder appVisibility(AppVisibility appVisibility) {
            this.appVisibility(appVisibility == null ? null : appVisibility.toString());
            return this;
        }

        public final List<EntitlementAttribute.Builder> getAttributes() {
            List<EntitlementAttribute.Builder> result = EntitlementAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<EntitlementAttribute.BuilderImpl> attributes) {
            this.attributes = EntitlementAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<EntitlementAttribute> attributes) {
            this.attributes = EntitlementAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(EntitlementAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<EntitlementAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> EntitlementAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEntitlementRequest build() {
            return new UpdateEntitlementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
