/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ApplicationSettings;
import software.amazon.awssdk.services.appstream.model.EmbedHostDomainsCopier;
import software.amazon.awssdk.services.appstream.model.StackAttribute;
import software.amazon.awssdk.services.appstream.model.StackAttributesCopier;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.services.appstream.model.UserSetting;
import software.amazon.awssdk.services.appstream.model.UserSettingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStackRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateStackRequest.getter(UpdateStackRequest::displayName)).setter(UpdateStackRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateStackRequest.getter(UpdateStackRequest::description)).setter(UpdateStackRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateStackRequest.getter(UpdateStackRequest::name)).setter(UpdateStackRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageConnectors").getter(UpdateStackRequest.getter(UpdateStackRequest::storageConnectors)).setter(UpdateStackRequest.setter(Builder::storageConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETE_STORAGE_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteStorageConnectors").getter(UpdateStackRequest.getter(UpdateStackRequest::deleteStorageConnectors)).setter(UpdateStackRequest.setter(Builder::deleteStorageConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteStorageConnectors").build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectURL").getter(UpdateStackRequest.getter(UpdateStackRequest::redirectURL)).setter(UpdateStackRequest.setter(Builder::redirectURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectURL").build()}).build();
    private static final SdkField<String> FEEDBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackURL").getter(UpdateStackRequest.getter(UpdateStackRequest::feedbackURL)).setter(UpdateStackRequest.setter(Builder::feedbackURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackURL").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToDelete").getter(UpdateStackRequest.getter(UpdateStackRequest::attributesToDeleteAsStrings)).setter(UpdateStackRequest.setter(Builder::attributesToDeleteWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserSettings").getter(UpdateStackRequest.getter(UpdateStackRequest::userSettings)).setter(UpdateStackRequest.setter(Builder::userSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationSettings> APPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSettings").getter(UpdateStackRequest.getter(UpdateStackRequest::applicationSettings)).setter(UpdateStackRequest.setter(Builder::applicationSettings)).constructor(ApplicationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessEndpoints").getter(UpdateStackRequest.getter(UpdateStackRequest::accessEndpoints)).setter(UpdateStackRequest.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EMBED_HOST_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmbedHostDomains").getter(UpdateStackRequest.getter(UpdateStackRequest::embedHostDomains)).setter(UpdateStackRequest.setter(Builder::embedHostDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmbedHostDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, STORAGE_CONNECTORS_FIELD, DELETE_STORAGE_CONNECTORS_FIELD, REDIRECT_URL_FIELD, FEEDBACK_URL_FIELD, ATTRIBUTES_TO_DELETE_FIELD, USER_SETTINGS_FIELD, APPLICATION_SETTINGS_FIELD, ACCESS_ENDPOINTS_FIELD, EMBED_HOST_DOMAINS_FIELD));
    private final String displayName;
    private final String description;
    private final String name;
    private final List<StorageConnector> storageConnectors;
    private final Boolean deleteStorageConnectors;
    private final String redirectURL;
    private final String feedbackURL;
    private final List<String> attributesToDelete;
    private final List<UserSetting> userSettings;
    private final ApplicationSettings applicationSettings;
    private final List<AccessEndpoint> accessEndpoints;
    private final List<String> embedHostDomains;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.name = builder.name;
        this.storageConnectors = builder.storageConnectors;
        this.deleteStorageConnectors = builder.deleteStorageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.attributesToDelete = builder.attributesToDelete;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
        this.accessEndpoints = builder.accessEndpoints;
        this.embedHostDomains = builder.embedHostDomains;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasStorageConnectors() {
        return this.storageConnectors != null && !(this.storageConnectors instanceof SdkAutoConstructList);
    }

    public final List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    @Deprecated
    public final Boolean deleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    public final String redirectURL() {
        return this.redirectURL;
    }

    public final String feedbackURL() {
        return this.feedbackURL;
    }

    public final List<StackAttribute> attributesToDelete() {
        return StackAttributesCopier.copyStringToEnum(this.attributesToDelete);
    }

    public final boolean hasAttributesToDelete() {
        return this.attributesToDelete != null && !(this.attributesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToDeleteAsStrings() {
        return this.attributesToDelete;
    }

    public final boolean hasUserSettings() {
        return this.userSettings != null && !(this.userSettings instanceof SdkAutoConstructList);
    }

    public final List<UserSetting> userSettings() {
        return this.userSettings;
    }

    public final ApplicationSettings applicationSettings() {
        return this.applicationSettings;
    }

    public final boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public final List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    public final boolean hasEmbedHostDomains() {
        return this.embedHostDomains != null && !(this.embedHostDomains instanceof SdkAutoConstructList);
    }

    public final List<String> embedHostDomains() {
        return this.embedHostDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConnectors() ? this.storageConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteStorageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserSettings() ? this.userSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessEndpoints() ? this.accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmbedHostDomains() ? this.embedHostDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && this.hasStorageConnectors() == other.hasStorageConnectors() && Objects.equals(this.storageConnectors(), other.storageConnectors()) && Objects.equals(this.deleteStorageConnectors(), other.deleteStorageConnectors()) && Objects.equals(this.redirectURL(), other.redirectURL()) && Objects.equals(this.feedbackURL(), other.feedbackURL()) && this.hasAttributesToDelete() == other.hasAttributesToDelete() && Objects.equals(this.attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings()) && this.hasUserSettings() == other.hasUserSettings() && Objects.equals(this.userSettings(), other.userSettings()) && Objects.equals(this.applicationSettings(), other.applicationSettings()) && this.hasAccessEndpoints() == other.hasAccessEndpoints() && Objects.equals(this.accessEndpoints(), other.accessEndpoints()) && this.hasEmbedHostDomains() == other.hasEmbedHostDomains() && Objects.equals(this.embedHostDomains(), other.embedHostDomains());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStackRequest").add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("StorageConnectors", this.hasStorageConnectors() ? this.storageConnectors() : null).add("DeleteStorageConnectors", (Object)this.deleteStorageConnectors()).add("RedirectURL", (Object)this.redirectURL()).add("FeedbackURL", (Object)this.feedbackURL()).add("AttributesToDelete", this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null).add("UserSettings", this.hasUserSettings() ? this.userSettings() : null).add("ApplicationSettings", (Object)this.applicationSettings()).add("AccessEndpoints", this.hasAccessEndpoints() ? this.accessEndpoints() : null).add("EmbedHostDomains", this.hasEmbedHostDomains() ? this.embedHostDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.storageConnectors()));
            }
            case "DeleteStorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.deleteStorageConnectors()));
            }
            case "RedirectURL": {
                return Optional.ofNullable(clazz.cast(this.redirectURL()));
            }
            case "FeedbackURL": {
                return Optional.ofNullable(clazz.cast(this.feedbackURL()));
            }
            case "AttributesToDelete": {
                return Optional.ofNullable(clazz.cast(this.attributesToDeleteAsStrings()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
            case "EmbedHostDomains": {
                return Optional.ofNullable(clazz.cast(this.embedHostDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStackRequest, T> g) {
        return obj -> g.apply((UpdateStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String displayName;
        private String description;
        private String name;
        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteStorageConnectors;
        private String redirectURL;
        private String feedbackURL;
        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();
        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();
        private ApplicationSettings applicationSettings;
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> embedHostDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            super(model);
            this.displayName(model.displayName);
            this.description(model.description);
            this.name(model.name);
            this.storageConnectors(model.storageConnectors);
            this.deleteStorageConnectors(model.deleteStorageConnectors);
            this.redirectURL(model.redirectURL);
            this.feedbackURL(model.feedbackURL);
            this.attributesToDeleteWithStrings(model.attributesToDelete);
            this.userSettings(model.userSettings);
            this.applicationSettings(model.applicationSettings);
            this.accessEndpoints(model.accessEndpoints);
            this.embedHostDomains(model.embedHostDomains);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<StorageConnector.Builder> getStorageConnectors() {
            List<StorageConnector.Builder> result = StorageConnectorListCopier.copyToBuilder(this.storageConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder> ... storageConnectors) {
            this.storageConnectors(Stream.of(storageConnectors).map(c -> (StorageConnector)((StorageConnector.Builder)StorageConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Boolean getDeleteStorageConnectors() {
            return this.deleteStorageConnectors;
        }

        @Deprecated
        public final void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
        }

        @Override
        @Deprecated
        public final Builder deleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
            return this;
        }

        public final String getRedirectURL() {
            return this.redirectURL;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final String getFeedbackURL() {
            return this.feedbackURL;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final Collection<String> getAttributesToDelete() {
            if (this.attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToDelete;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String ... attributesToDelete) {
            this.attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<StackAttribute> attributesToDelete) {
            this.attributesToDelete = StackAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(StackAttribute ... attributesToDelete) {
            this.attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        public final List<UserSetting.Builder> getUserSettings() {
            List<UserSetting.Builder> result = UserSettingListCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting ... userSettings) {
            this.userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder> ... userSettings) {
            this.userSettings(Stream.of(userSettings).map(c -> (UserSetting)((UserSetting.Builder)UserSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApplicationSettings.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettings.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEmbedHostDomains() {
            if (this.embedHostDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.embedHostDomains;
        }

        public final void setEmbedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
        }

        @Override
        public final Builder embedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embedHostDomains(String ... embedHostDomains) {
            this.embedHostDomains(Arrays.asList(embedHostDomains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder storageConnectors(Consumer<StorageConnector.Builder> ... var1);

        @Deprecated
        public Builder deleteStorageConnectors(Boolean var1);

        public Builder redirectURL(String var1);

        public Builder feedbackURL(String var1);

        public Builder attributesToDeleteWithStrings(Collection<String> var1);

        public Builder attributesToDeleteWithStrings(String ... var1);

        public Builder attributesToDelete(Collection<StackAttribute> var1);

        public Builder attributesToDelete(StackAttribute ... var1);

        public Builder userSettings(Collection<UserSetting> var1);

        public Builder userSettings(UserSetting ... var1);

        public Builder userSettings(Consumer<UserSetting.Builder> ... var1);

        public Builder applicationSettings(ApplicationSettings var1);

        default public Builder applicationSettings(Consumer<ApplicationSettings.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettings)((ApplicationSettings.Builder)ApplicationSettings.builder().applyMutation(applicationSettings)).build());
        }

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);

        public Builder embedHostDomains(Collection<String> var1);

        public Builder embedHostDomains(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

