/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateApplicationFleetResponse extends AppStreamResponse implements
        ToCopyableBuilder<AssociateApplicationFleetResponse.Builder, AssociateApplicationFleetResponse> {
    private static final SdkField<ApplicationFleetAssociation> APPLICATION_FLEET_ASSOCIATION_FIELD = SdkField
            .<ApplicationFleetAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationFleetAssociation")
            .getter(getter(AssociateApplicationFleetResponse::applicationFleetAssociation))
            .setter(setter(Builder::applicationFleetAssociation))
            .constructor(ApplicationFleetAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationFleetAssociation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_FLEET_ASSOCIATION_FIELD));

    private final ApplicationFleetAssociation applicationFleetAssociation;

    private AssociateApplicationFleetResponse(BuilderImpl builder) {
        super(builder);
        this.applicationFleetAssociation = builder.applicationFleetAssociation;
    }

    /**
     * <p>
     * If fleet name is specified, this returns the list of applications that are associated to it. If application ARN
     * is specified, this returns the list of fleets to which it is associated.
     * </p>
     * 
     * @return If fleet name is specified, this returns the list of applications that are associated to it. If
     *         application ARN is specified, this returns the list of fleets to which it is associated.
     */
    public final ApplicationFleetAssociation applicationFleetAssociation() {
        return applicationFleetAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationFleetAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateApplicationFleetResponse)) {
            return false;
        }
        AssociateApplicationFleetResponse other = (AssociateApplicationFleetResponse) obj;
        return Objects.equals(applicationFleetAssociation(), other.applicationFleetAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateApplicationFleetResponse")
                .add("ApplicationFleetAssociation", applicationFleetAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationFleetAssociation":
            return Optional.ofNullable(clazz.cast(applicationFleetAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateApplicationFleetResponse, T> g) {
        return obj -> g.apply((AssociateApplicationFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateApplicationFleetResponse> {
        /**
         * <p>
         * If fleet name is specified, this returns the list of applications that are associated to it. If application
         * ARN is specified, this returns the list of fleets to which it is associated.
         * </p>
         * 
         * @param applicationFleetAssociation
         *        If fleet name is specified, this returns the list of applications that are associated to it. If
         *        application ARN is specified, this returns the list of fleets to which it is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationFleetAssociation(ApplicationFleetAssociation applicationFleetAssociation);

        /**
         * <p>
         * If fleet name is specified, this returns the list of applications that are associated to it. If application
         * ARN is specified, this returns the list of fleets to which it is associated.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationFleetAssociation.Builder}
         * avoiding the need to create one manually via {@link ApplicationFleetAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationFleetAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationFleetAssociation(ApplicationFleetAssociation)}.
         * 
         * @param applicationFleetAssociation
         *        a consumer that will call methods on {@link ApplicationFleetAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationFleetAssociation(ApplicationFleetAssociation)
         */
        default Builder applicationFleetAssociation(Consumer<ApplicationFleetAssociation.Builder> applicationFleetAssociation) {
            return applicationFleetAssociation(ApplicationFleetAssociation.builder().applyMutation(applicationFleetAssociation)
                    .build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private ApplicationFleetAssociation applicationFleetAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateApplicationFleetResponse model) {
            super(model);
            applicationFleetAssociation(model.applicationFleetAssociation);
        }

        public final ApplicationFleetAssociation.Builder getApplicationFleetAssociation() {
            return applicationFleetAssociation != null ? applicationFleetAssociation.toBuilder() : null;
        }

        public final void setApplicationFleetAssociation(ApplicationFleetAssociation.BuilderImpl applicationFleetAssociation) {
            this.applicationFleetAssociation = applicationFleetAssociation != null ? applicationFleetAssociation.build() : null;
        }

        @Override
        public final Builder applicationFleetAssociation(ApplicationFleetAssociation applicationFleetAssociation) {
            this.applicationFleetAssociation = applicationFleetAssociation;
            return this;
        }

        @Override
        public AssociateApplicationFleetResponse build() {
            return new AssociateApplicationFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
