/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDirectoryConfigResponse extends AppStreamResponse implements
        ToCopyableBuilder<CreateDirectoryConfigResponse.Builder, CreateDirectoryConfigResponse> {
    private static final SdkField<DirectoryConfig> DIRECTORY_CONFIG_FIELD = SdkField
            .<DirectoryConfig> builder(MarshallingType.SDK_POJO).memberName("DirectoryConfig")
            .getter(getter(CreateDirectoryConfigResponse::directoryConfig)).setter(setter(Builder::directoryConfig))
            .constructor(DirectoryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_CONFIG_FIELD));

    private final DirectoryConfig directoryConfig;

    private CreateDirectoryConfigResponse(BuilderImpl builder) {
        super(builder);
        this.directoryConfig = builder.directoryConfig;
    }

    /**
     * <p>
     * Information about the directory configuration.
     * </p>
     * 
     * @return Information about the directory configuration.
     */
    public final DirectoryConfig directoryConfig() {
        return directoryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryConfigResponse)) {
            return false;
        }
        CreateDirectoryConfigResponse other = (CreateDirectoryConfigResponse) obj;
        return Objects.equals(directoryConfig(), other.directoryConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDirectoryConfigResponse").add("DirectoryConfig", directoryConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryConfig":
            return Optional.ofNullable(clazz.cast(directoryConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectoryConfigResponse, T> g) {
        return obj -> g.apply((CreateDirectoryConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDirectoryConfigResponse> {
        /**
         * <p>
         * Information about the directory configuration.
         * </p>
         * 
         * @param directoryConfig
         *        Information about the directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryConfig(DirectoryConfig directoryConfig);

        /**
         * <p>
         * Information about the directory configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectoryConfig.Builder} avoiding the
         * need to create one manually via {@link DirectoryConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectoryConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #directoryConfig(DirectoryConfig)}.
         * 
         * @param directoryConfig
         *        a consumer that will call methods on {@link DirectoryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryConfig(DirectoryConfig)
         */
        default Builder directoryConfig(Consumer<DirectoryConfig.Builder> directoryConfig) {
            return directoryConfig(DirectoryConfig.builder().applyMutation(directoryConfig).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private DirectoryConfig directoryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryConfigResponse model) {
            super(model);
            directoryConfig(model.directoryConfig);
        }

        public final DirectoryConfig.Builder getDirectoryConfig() {
            return directoryConfig != null ? directoryConfig.toBuilder() : null;
        }

        public final void setDirectoryConfig(DirectoryConfig.BuilderImpl directoryConfig) {
            this.directoryConfig = directoryConfig != null ? directoryConfig.build() : null;
        }

        @Override
        public final Builder directoryConfig(DirectoryConfig directoryConfig) {
            this.directoryConfig = directoryConfig;
            return this;
        }

        @Override
        public CreateDirectoryConfigResponse build() {
            return new CreateDirectoryConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
