/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImagePermissionsRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateImagePermissionsRequest.Builder, UpdateImagePermissionsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateImagePermissionsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedAccountId").getter(getter(UpdateImagePermissionsRequest::sharedAccountId))
            .setter(setter(Builder::sharedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()).build();

    private static final SdkField<ImagePermissions> IMAGE_PERMISSIONS_FIELD = SdkField
            .<ImagePermissions> builder(MarshallingType.SDK_POJO).memberName("ImagePermissions")
            .getter(getter(UpdateImagePermissionsRequest::imagePermissions)).setter(setter(Builder::imagePermissions))
            .constructor(ImagePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePermissions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SHARED_ACCOUNT_ID_FIELD, IMAGE_PERMISSIONS_FIELD));

    private final String name;

    private final String sharedAccountId;

    private final ImagePermissions imagePermissions;

    private UpdateImagePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sharedAccountId = builder.sharedAccountId;
        this.imagePermissions = builder.imagePermissions;
    }

    /**
     * <p>
     * The name of the private image.
     * </p>
     * 
     * @return The name of the private image.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The 12-digit identifier of the AWS account for which you want add or update image permissions.
     * </p>
     * 
     * @return The 12-digit identifier of the AWS account for which you want add or update image permissions.
     */
    public final String sharedAccountId() {
        return sharedAccountId;
    }

    /**
     * <p>
     * The permissions for the image.
     * </p>
     * 
     * @return The permissions for the image.
     */
    public final ImagePermissions imagePermissions() {
        return imagePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(imagePermissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImagePermissionsRequest)) {
            return false;
        }
        UpdateImagePermissionsRequest other = (UpdateImagePermissionsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(sharedAccountId(), other.sharedAccountId())
                && Objects.equals(imagePermissions(), other.imagePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImagePermissionsRequest").add("Name", name()).add("SharedAccountId", sharedAccountId())
                .add("ImagePermissions", imagePermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        case "ImagePermissions":
            return Optional.ofNullable(clazz.cast(imagePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImagePermissionsRequest, T> g) {
        return obj -> g.apply((UpdateImagePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateImagePermissionsRequest> {
        /**
         * <p>
         * The name of the private image.
         * </p>
         * 
         * @param name
         *        The name of the private image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The 12-digit identifier of the AWS account for which you want add or update image permissions.
         * </p>
         * 
         * @param sharedAccountId
         *        The 12-digit identifier of the AWS account for which you want add or update image permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        /**
         * <p>
         * The permissions for the image.
         * </p>
         * 
         * @param imagePermissions
         *        The permissions for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(ImagePermissions imagePermissions);

        /**
         * <p>
         * The permissions for the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImagePermissions.Builder} avoiding the
         * need to create one manually via {@link ImagePermissions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImagePermissions.Builder#build()} is called immediately and its
         * result is passed to {@link #imagePermissions(ImagePermissions)}.
         * 
         * @param imagePermissions
         *        a consumer that will call methods on {@link ImagePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePermissions(ImagePermissions)
         */
        default Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return imagePermissions(ImagePermissions.builder().applyMutation(imagePermissions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String sharedAccountId;

        private ImagePermissions imagePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImagePermissionsRequest model) {
            super(model);
            name(model.name);
            sharedAccountId(model.sharedAccountId);
            imagePermissions(model.imagePermissions);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return imagePermissions != null ? imagePermissions.toBuilder() : null;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImagePermissionsRequest build() {
            return new UpdateImagePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
