/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppBlockRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateAppBlockRequest.Builder, CreateAppBlockRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAppBlockRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateAppBlockRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateAppBlockRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<S3Location> SOURCE_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("SourceS3Location").getter(getter(CreateAppBlockRequest::sourceS3Location))
            .setter(setter(Builder::sourceS3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Location").build()).build();

    private static final SdkField<ScriptDetails> SETUP_SCRIPT_DETAILS_FIELD = SdkField
            .<ScriptDetails> builder(MarshallingType.SDK_POJO).memberName("SetupScriptDetails")
            .getter(getter(CreateAppBlockRequest::setupScriptDetails)).setter(setter(Builder::setupScriptDetails))
            .constructor(ScriptDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupScriptDetails").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAppBlockRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DISPLAY_NAME_FIELD, SOURCE_S3_LOCATION_FIELD, SETUP_SCRIPT_DETAILS_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String displayName;

    private final S3Location sourceS3Location;

    private final ScriptDetails setupScriptDetails;

    private final Map<String, String> tags;

    private CreateAppBlockRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.sourceS3Location = builder.sourceS3Location;
        this.setupScriptDetails = builder.setupScriptDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the app block.
     * </p>
     * 
     * @return The name of the app block.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the app block.
     * </p>
     * 
     * @return The description of the app block.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the app block. This is not displayed to the user.
     * </p>
     * 
     * @return The display name of the app block. This is not displayed to the user.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The source S3 location of the app block.
     * </p>
     * 
     * @return The source S3 location of the app block.
     */
    public final S3Location sourceS3Location() {
        return sourceS3Location;
    }

    /**
     * <p>
     * The setup script details of the app block.
     * </p>
     * 
     * @return The setup script details of the app block.
     */
    public final ScriptDetails setupScriptDetails() {
        return setupScriptDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the app block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the app block.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(setupScriptDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppBlockRequest)) {
            return false;
        }
        CreateAppBlockRequest other = (CreateAppBlockRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(sourceS3Location(), other.sourceS3Location())
                && Objects.equals(setupScriptDetails(), other.setupScriptDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppBlockRequest").add("Name", name()).add("Description", description())
                .add("DisplayName", displayName()).add("SourceS3Location", sourceS3Location())
                .add("SetupScriptDetails", setupScriptDetails()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "SourceS3Location":
            return Optional.ofNullable(clazz.cast(sourceS3Location()));
        case "SetupScriptDetails":
            return Optional.ofNullable(clazz.cast(setupScriptDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppBlockRequest, T> g) {
        return obj -> g.apply((CreateAppBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppBlockRequest> {
        /**
         * <p>
         * The name of the app block.
         * </p>
         * 
         * @param name
         *        The name of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the app block.
         * </p>
         * 
         * @param description
         *        The description of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the app block. This is not displayed to the user.
         * </p>
         * 
         * @param displayName
         *        The display name of the app block. This is not displayed to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The source S3 location of the app block.
         * </p>
         * 
         * @param sourceS3Location
         *        The source S3 location of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Location(S3Location sourceS3Location);

        /**
         * <p>
         * The source S3 location of the app block.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceS3Location(S3Location)}.
         * 
         * @param sourceS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Location(S3Location)
         */
        default Builder sourceS3Location(Consumer<S3Location.Builder> sourceS3Location) {
            return sourceS3Location(S3Location.builder().applyMutation(sourceS3Location).build());
        }

        /**
         * <p>
         * The setup script details of the app block.
         * </p>
         * 
         * @param setupScriptDetails
         *        The setup script details of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupScriptDetails(ScriptDetails setupScriptDetails);

        /**
         * <p>
         * The setup script details of the app block.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScriptDetails.Builder} avoiding the need
         * to create one manually via {@link ScriptDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScriptDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #setupScriptDetails(ScriptDetails)}.
         * 
         * @param setupScriptDetails
         *        a consumer that will call methods on {@link ScriptDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setupScriptDetails(ScriptDetails)
         */
        default Builder setupScriptDetails(Consumer<ScriptDetails.Builder> setupScriptDetails) {
            return setupScriptDetails(ScriptDetails.builder().applyMutation(setupScriptDetails).build());
        }

        /**
         * <p>
         * The tags assigned to the app block.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String displayName;

        private S3Location sourceS3Location;

        private ScriptDetails setupScriptDetails;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppBlockRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            displayName(model.displayName);
            sourceS3Location(model.sourceS3Location);
            setupScriptDetails(model.setupScriptDetails);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final S3Location.Builder getSourceS3Location() {
            return sourceS3Location != null ? sourceS3Location.toBuilder() : null;
        }

        public final void setSourceS3Location(S3Location.BuilderImpl sourceS3Location) {
            this.sourceS3Location = sourceS3Location != null ? sourceS3Location.build() : null;
        }

        @Override
        public final Builder sourceS3Location(S3Location sourceS3Location) {
            this.sourceS3Location = sourceS3Location;
            return this;
        }

        public final ScriptDetails.Builder getSetupScriptDetails() {
            return setupScriptDetails != null ? setupScriptDetails.toBuilder() : null;
        }

        public final void setSetupScriptDetails(ScriptDetails.BuilderImpl setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails != null ? setupScriptDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder setupScriptDetails(ScriptDetails setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppBlockRequest build() {
            return new CreateAppBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
