/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessEndpointType {
    STREAMING("STREAMING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessEndpointType> VALUE_MAP;
    private final String value;

    private AccessEndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessEndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessEndpointType> knownValues() {
        EnumSet<AccessEndpointType> knownValues = EnumSet.allOf(AccessEndpointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessEndpointType.class, AccessEndpointType::toString);
    }
}

