/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamView {
    APP("APP"),
    DESKTOP("DESKTOP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamView> VALUE_MAP;
    private final String value;

    private StreamView(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamView fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamView> knownValues() {
        EnumSet<StreamView> knownValues = EnumSet.allOf(StreamView.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamView.class, StreamView::toString);
    }
}

