/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateStackRequest.Builder, CreateStackRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateStackRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateStackRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateStackRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField
            .<List<StorageConnector>> builder(MarshallingType.LIST)
            .memberName("StorageConnectors")
            .getter(getter(CreateStackRequest::storageConnectors))
            .setter(setter(Builder::storageConnectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageConnector> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageConnector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedirectURL").getter(getter(CreateStackRequest::redirectURL)).setter(setter(Builder::redirectURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectURL").build()).build();

    private static final SdkField<String> FEEDBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackURL").getter(getter(CreateStackRequest::feedbackURL)).setter(setter(Builder::feedbackURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackURL").build()).build();

    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField
            .<List<UserSetting>> builder(MarshallingType.LIST)
            .memberName("UserSettings")
            .getter(getter(CreateStackRequest::userSettings))
            .setter(setter(Builder::userSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationSettings> APPLICATION_SETTINGS_FIELD = SdkField
            .<ApplicationSettings> builder(MarshallingType.SDK_POJO).memberName("ApplicationSettings")
            .getter(getter(CreateStackRequest::applicationSettings)).setter(setter(Builder::applicationSettings))
            .constructor(ApplicationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateStackRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField
            .<List<AccessEndpoint>> builder(MarshallingType.LIST)
            .memberName("AccessEndpoints")
            .getter(getter(CreateStackRequest::accessEndpoints))
            .setter(setter(Builder::accessEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EMBED_HOST_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EmbedHostDomains")
            .getter(getter(CreateStackRequest::embedHostDomains))
            .setter(setter(Builder::embedHostDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmbedHostDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DISPLAY_NAME_FIELD, STORAGE_CONNECTORS_FIELD, REDIRECT_URL_FIELD, FEEDBACK_URL_FIELD, USER_SETTINGS_FIELD,
            APPLICATION_SETTINGS_FIELD, TAGS_FIELD, ACCESS_ENDPOINTS_FIELD, EMBED_HOST_DOMAINS_FIELD));

    private final String name;

    private final String description;

    private final String displayName;

    private final List<StorageConnector> storageConnectors;

    private final String redirectURL;

    private final String feedbackURL;

    private final List<UserSetting> userSettings;

    private final ApplicationSettings applicationSettings;

    private final Map<String, String> tags;

    private final List<AccessEndpoint> accessEndpoints;

    private final List<String> embedHostDomains;

    private CreateStackRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.storageConnectors = builder.storageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
        this.tags = builder.tags;
        this.accessEndpoints = builder.accessEndpoints;
        this.embedHostDomains = builder.embedHostDomains;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description to display.
     * </p>
     * 
     * @return The description to display.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The stack name to display.
     * </p>
     * 
     * @return The stack name to display.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageConnectors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageConnectors() {
        return storageConnectors != null && !(storageConnectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The storage connectors to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageConnectors} method.
     * </p>
     * 
     * @return The storage connectors to enable.
     */
    public final List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * The URL that users are redirected to after their streaming session ends.
     * </p>
     * 
     * @return The URL that users are redirected to after their streaming session ends.
     */
    public final String redirectURL() {
        return redirectURL;
    }

    /**
     * <p>
     * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send
     * Feedback link is displayed.
     * </p>
     * 
     * @return The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no
     *         Send Feedback link is displayed.
     */
    public final String feedbackURL() {
        return feedbackURL;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserSettings() {
        return userSettings != null && !(userSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are
     * enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserSettings} method.
     * </p>
     * 
     * @return The actions that are enabled or disabled for users during their streaming sessions. By default, these
     *         actions are enabled.
     */
    public final List<UserSetting> userSettings() {
        return userSettings;
    }

    /**
     * <p>
     * The persistent application settings for users of a stack. When these settings are enabled, changes that users
     * make to applications and Windows settings are automatically saved after each session and applied to the next
     * session.
     * </p>
     * 
     * @return The persistent application settings for users of a stack. When these settings are enabled, changes that
     *         users make to applications and Windows settings are automatically saved after each session and applied to
     *         the next session.
     */
    public final ApplicationSettings applicationSettings() {
        return applicationSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example,
     * Environment=Test. If you do not specify a value, Environment=.
     * </p>
     * <p>
     * If you do not specify a value, the value is set to an empty string.
     * </p>
     * <p>
     * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special
     * characters:
     * </p>
     * <p>
     * _ . : / = + \ - @
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example,
     *         Environment=Test. If you do not specify a value, Environment=. </p>
     *         <p>
     *         If you do not specify a value, the value is set to an empty string.
     *         </p>
     *         <p>
     *         Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
     *         special characters:
     *         </p>
     *         <p>
     *         _ . : / = + \ - @
     *         </p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
     *         Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessEndpoints() {
        return accessEndpoints != null && !(accessEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0
     * only through the specified endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessEndpoints} method.
     * </p>
     * 
     * @return The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to
     *         AppStream 2.0 only through the specified endpoints.
     */
    public final List<AccessEndpoint> accessEndpoints() {
        return accessEndpoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmbedHostDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmbedHostDomains() {
        return embedHostDomains != null && !(embedHostDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
     * that you want to host embedded AppStream 2.0 streaming sessions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmbedHostDomains} method.
     * </p>
     * 
     * @return The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
     *         domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    public final List<String> embedHostDomains() {
        return embedHostDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageConnectors() ? storageConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserSettings() ? userSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessEndpoints() ? accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEmbedHostDomains() ? embedHostDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName()) && hasStorageConnectors() == other.hasStorageConnectors()
                && Objects.equals(storageConnectors(), other.storageConnectors())
                && Objects.equals(redirectURL(), other.redirectURL()) && Objects.equals(feedbackURL(), other.feedbackURL())
                && hasUserSettings() == other.hasUserSettings() && Objects.equals(userSettings(), other.userSettings())
                && Objects.equals(applicationSettings(), other.applicationSettings()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasAccessEndpoints() == other.hasAccessEndpoints()
                && Objects.equals(accessEndpoints(), other.accessEndpoints())
                && hasEmbedHostDomains() == other.hasEmbedHostDomains()
                && Objects.equals(embedHostDomains(), other.embedHostDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStackRequest").add("Name", name()).add("Description", description())
                .add("DisplayName", displayName()).add("StorageConnectors", hasStorageConnectors() ? storageConnectors() : null)
                .add("RedirectURL", redirectURL()).add("FeedbackURL", feedbackURL())
                .add("UserSettings", hasUserSettings() ? userSettings() : null).add("ApplicationSettings", applicationSettings())
                .add("Tags", hasTags() ? tags() : null).add("AccessEndpoints", hasAccessEndpoints() ? accessEndpoints() : null)
                .add("EmbedHostDomains", hasEmbedHostDomains() ? embedHostDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "StorageConnectors":
            return Optional.ofNullable(clazz.cast(storageConnectors()));
        case "RedirectURL":
            return Optional.ofNullable(clazz.cast(redirectURL()));
        case "FeedbackURL":
            return Optional.ofNullable(clazz.cast(feedbackURL()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        case "ApplicationSettings":
            return Optional.ofNullable(clazz.cast(applicationSettings()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AccessEndpoints":
            return Optional.ofNullable(clazz.cast(accessEndpoints()));
        case "EmbedHostDomains":
            return Optional.ofNullable(clazz.cast(embedHostDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRequest, T> g) {
        return obj -> g.apply((CreateStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStackRequest> {
        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param name
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description to display.
         * </p>
         * 
         * @param description
         *        The description to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stack name to display.
         * </p>
         * 
         * @param displayName
         *        The stack name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StorageConnector>.Builder} avoiding the
         * need to create one manually via {@link List<StorageConnector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageConnector>.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConnectors(List<StorageConnector>)}.
         * 
         * @param storageConnectors
         *        a consumer that will call methods on {@link List<StorageConnector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConnectors(List<StorageConnector>)
         */
        Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors);

        /**
         * <p>
         * The URL that users are redirected to after their streaming session ends.
         * </p>
         * 
         * @param redirectURL
         *        The URL that users are redirected to after their streaming session ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectURL(String redirectURL);

        /**
         * <p>
         * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send
         * Feedback link is displayed.
         * </p>
         * 
         * @param feedbackURL
         *        The URL that users are redirected to after they click the Send Feedback link. If no URL is specified,
         *        no Send Feedback link is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackURL(String feedbackURL);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default, these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(Collection<UserSetting> userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * 
         * @param userSettings
         *        The actions that are enabled or disabled for users during their streaming sessions. By default, these
         *        actions are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSetting... userSettings);

        /**
         * <p>
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions
         * are enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserSetting>.Builder} avoiding the need to
         * create one manually via {@link List<UserSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserSetting>.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(List<UserSetting>)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link List<UserSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(List<UserSetting>)
         */
        Builder userSettings(Consumer<UserSetting.Builder>... userSettings);

        /**
         * <p>
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users
         * make to applications and Windows settings are automatically saved after each session and applied to the next
         * session.
         * </p>
         * 
         * @param applicationSettings
         *        The persistent application settings for users of a stack. When these settings are enabled, changes
         *        that users make to applications and Windows settings are automatically saved after each session and
         *        applied to the next session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSettings(ApplicationSettings applicationSettings);

        /**
         * <p>
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users
         * make to applications and Windows settings are automatically saved after each session and applied to the next
         * session.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSettings.Builder} avoiding the need
         * to create one manually via {@link ApplicationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationSettings(ApplicationSettings)}.
         * 
         * @param applicationSettings
         *        a consumer that will call methods on {@link ApplicationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSettings(ApplicationSettings)
         */
        default Builder applicationSettings(Consumer<ApplicationSettings.Builder> applicationSettings) {
            return applicationSettings(ApplicationSettings.builder().applyMutation(applicationSettings).build());
        }

        /**
         * <p>
         * The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example,
         * Environment=Test. If you do not specify a value, Environment=.
         * </p>
         * <p>
         * If you do not specify a value, the value is set to an empty string.
         * </p>
         * <p>
         * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
         * special characters:
         * </p>
         * <p>
         * _ . : / = + \ - @
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         * Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For
         *        example, Environment=Test. If you do not specify a value, Environment=. </p>
         *        <p>
         *        If you do not specify a value, the value is set to an empty string.
         *        </p>
         *        <p>
         *        Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the
         *        following special characters:
         *        </p>
         *        <p>
         *        _ . : / = + \ - @
         *        </p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         *        Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream
         * 2.0 only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to
         *        AppStream 2.0 only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream
         * 2.0 only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to
         *        AppStream 2.0 only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(AccessEndpoint... accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream
         * 2.0 only through the specified endpoints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessEndpoint>.Builder} avoiding the need
         * to create one manually via {@link List<AccessEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #accessEndpoints(List<AccessEndpoint>)}.
         * 
         * @param accessEndpoints
         *        a consumer that will call methods on {@link List<AccessEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessEndpoints(List<AccessEndpoint>)
         */
        Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints);

        /**
         * <p>
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
         * that you want to host embedded AppStream 2.0 streaming sessions.
         * </p>
         * 
         * @param embedHostDomains
         *        The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
         *        domains that you want to host embedded AppStream 2.0 streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embedHostDomains(Collection<String> embedHostDomains);

        /**
         * <p>
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains
         * that you want to host embedded AppStream 2.0 streaming sessions.
         * </p>
         * 
         * @param embedHostDomains
         *        The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the
         *        domains that you want to host embedded AppStream 2.0 streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embedHostDomains(String... embedHostDomains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String displayName;

        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();

        private String redirectURL;

        private String feedbackURL;

        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();

        private ApplicationSettings applicationSettings;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> embedHostDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            displayName(model.displayName);
            storageConnectors(model.storageConnectors);
            redirectURL(model.redirectURL);
            feedbackURL(model.feedbackURL);
            userSettings(model.userSettings);
            applicationSettings(model.applicationSettings);
            tags(model.tags);
            accessEndpoints(model.accessEndpoints);
            embedHostDomains(model.embedHostDomains);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<StorageConnector.Builder> getStorageConnectors() {
            List<StorageConnector.Builder> result = StorageConnectorListCopier.copyToBuilder(this.storageConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        @Override
        @Transient
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors) {
            storageConnectors(Stream.of(storageConnectors).map(c -> StorageConnector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRedirectURL() {
            return redirectURL;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        @Override
        @Transient
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final String getFeedbackURL() {
            return feedbackURL;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        @Override
        @Transient
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final List<UserSetting.Builder> getUserSettings() {
            List<UserSetting.Builder> result = UserSettingListCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        @Override
        @Transient
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userSettings(UserSetting... userSettings) {
            userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder>... userSettings) {
            userSettings(Stream.of(userSettings).map(c -> UserSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ApplicationSettings.Builder getApplicationSettings() {
            return applicationSettings != null ? applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettings.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder applicationSettings(ApplicationSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        @Transient
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint... accessEndpoints) {
            accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints) {
            accessEndpoints(Stream.of(accessEndpoints).map(c -> AccessEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEmbedHostDomains() {
            if (embedHostDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return embedHostDomains;
        }

        public final void setEmbedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
        }

        @Override
        @Transient
        public final Builder embedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder embedHostDomains(String... embedHostDomains) {
            embedHostDomains(Arrays.asList(embedHostDomains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
