/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUsageReportSubscriptionResponse extends AppStreamResponse implements
        ToCopyableBuilder<CreateUsageReportSubscriptionResponse.Builder, CreateUsageReportSubscriptionResponse> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(CreateUsageReportSubscriptionResponse::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(CreateUsageReportSubscriptionResponse::scheduleAsString))
            .setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            SCHEDULE_FIELD));

    private final String s3BucketName;

    private final String schedule;

    private CreateUsageReportSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.s3BucketName = builder.s3BucketName;
        this.schedule = builder.schedule;
    }

    /**
     * <p>
     * The Amazon S3 bucket where generated reports are stored.
     * </p>
     * <p>
     * If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration, AppStream
     * 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and Region. When you
     * enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage reports. If you
     * haven't already enabled on-instance session scripts, when you enable usage reports, AppStream 2.0 creates a new
     * S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 bucket where generated reports are stored.</p>
     *         <p>
     *         If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration,
     *         AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and
     *         Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your
     *         usage reports. If you haven't already enabled on-instance session scripts, when you enable usage reports,
     *         AppStream 2.0 creates a new S3 bucket.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The schedule for generating usage reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link UsageReportSchedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleAsString}.
     * </p>
     * 
     * @return The schedule for generating usage reports.
     * @see UsageReportSchedule
     */
    public final UsageReportSchedule schedule() {
        return UsageReportSchedule.fromValue(schedule);
    }

    /**
     * <p>
     * The schedule for generating usage reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link UsageReportSchedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleAsString}.
     * </p>
     * 
     * @return The schedule for generating usage reports.
     * @see UsageReportSchedule
     */
    public final String scheduleAsString() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsageReportSubscriptionResponse)) {
            return false;
        }
        CreateUsageReportSubscriptionResponse other = (CreateUsageReportSubscriptionResponse) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(scheduleAsString(), other.scheduleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUsageReportSubscriptionResponse").add("S3BucketName", s3BucketName())
                .add("Schedule", scheduleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(scheduleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUsageReportSubscriptionResponse, T> g) {
        return obj -> g.apply((CreateUsageReportSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateUsageReportSubscriptionResponse> {
        /**
         * <p>
         * The Amazon S3 bucket where generated reports are stored.
         * </p>
         * <p>
         * If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration,
         * AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and
         * Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage
         * reports. If you haven't already enabled on-instance session scripts, when you enable usage reports, AppStream
         * 2.0 creates a new S3 bucket.
         * </p>
         * 
         * @param s3BucketName
         *        The Amazon S3 bucket where generated reports are stored.</p>
         *        <p>
         *        If you enabled on-instance session scripts and Amazon S3 logging for your session script
         *        configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to
         *        your account and Region. When you enable usage reporting in this case, AppStream 2.0 uses the same
         *        bucket to store your usage reports. If you haven't already enabled on-instance session scripts, when
         *        you enable usage reports, AppStream 2.0 creates a new S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The schedule for generating usage reports.
         * </p>
         * 
         * @param schedule
         *        The schedule for generating usage reports.
         * @see UsageReportSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageReportSchedule
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The schedule for generating usage reports.
         * </p>
         * 
         * @param schedule
         *        The schedule for generating usage reports.
         * @see UsageReportSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageReportSchedule
         */
        Builder schedule(UsageReportSchedule schedule);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private String s3BucketName;

        private String schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsageReportSubscriptionResponse model) {
            super(model);
            s3BucketName(model.s3BucketName);
            schedule(model.schedule);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        @Transient
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        @Transient
        public final Builder schedule(UsageReportSchedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        @Override
        public CreateUsageReportSubscriptionResponse build() {
            return new CreateUsageReportSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
