/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.appstream.model.AppStreamException;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetRequest;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetResponse;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.AssociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.AssociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest;
import software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackResponse;
import software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest;
import software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackResponse;
import software.amazon.awssdk.services.appstream.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appstream.model.CopyImageRequest;
import software.amazon.awssdk.services.appstream.model.CopyImageResponse;
import software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest;
import software.amazon.awssdk.services.appstream.model.CreateAppBlockResponse;
import software.amazon.awssdk.services.appstream.model.CreateApplicationRequest;
import software.amazon.awssdk.services.appstream.model.CreateApplicationResponse;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.CreateEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.CreateFleetRequest;
import software.amazon.awssdk.services.appstream.model.CreateFleetResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.CreateStackRequest;
import software.amazon.awssdk.services.appstream.model.CreateStackResponse;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest;
import software.amazon.awssdk.services.appstream.model.CreateUpdatedImageResponse;
import software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionRequest;
import software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionResponse;
import software.amazon.awssdk.services.appstream.model.CreateUserRequest;
import software.amazon.awssdk.services.appstream.model.CreateUserResponse;
import software.amazon.awssdk.services.appstream.model.DeleteAppBlockRequest;
import software.amazon.awssdk.services.appstream.model.DeleteAppBlockResponse;
import software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.appstream.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.DeleteEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.DeleteFleetRequest;
import software.amazon.awssdk.services.appstream.model.DeleteFleetResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageResponse;
import software.amazon.awssdk.services.appstream.model.DeleteStackRequest;
import software.amazon.awssdk.services.appstream.model.DeleteStackResponse;
import software.amazon.awssdk.services.appstream.model.DeleteUsageReportSubscriptionRequest;
import software.amazon.awssdk.services.appstream.model.DeleteUsageReportSubscriptionResponse;
import software.amazon.awssdk.services.appstream.model.DeleteUserRequest;
import software.amazon.awssdk.services.appstream.model.DeleteUserResponse;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlocksResponse;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeEntitlementsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeStacksRequest;
import software.amazon.awssdk.services.appstream.model.DescribeStacksResponse;
import software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeUsersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeUsersResponse;
import software.amazon.awssdk.services.appstream.model.DisableUserRequest;
import software.amazon.awssdk.services.appstream.model.DisableUserResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.EnableUserRequest;
import software.amazon.awssdk.services.appstream.model.EnableUserResponse;
import software.amazon.awssdk.services.appstream.model.EntitlementAlreadyExistsException;
import software.amazon.awssdk.services.appstream.model.EntitlementNotFoundException;
import software.amazon.awssdk.services.appstream.model.ExpireSessionRequest;
import software.amazon.awssdk.services.appstream.model.ExpireSessionResponse;
import software.amazon.awssdk.services.appstream.model.IncompatibleImageException;
import software.amazon.awssdk.services.appstream.model.InvalidAccountStatusException;
import software.amazon.awssdk.services.appstream.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.appstream.model.InvalidRoleException;
import software.amazon.awssdk.services.appstream.model.LimitExceededException;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksResponse;
import software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest;
import software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsResponse;
import software.amazon.awssdk.services.appstream.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appstream.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appstream.model.OperationNotPermittedException;
import software.amazon.awssdk.services.appstream.model.RequestLimitExceededException;
import software.amazon.awssdk.services.appstream.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.appstream.model.ResourceInUseException;
import software.amazon.awssdk.services.appstream.model.ResourceNotAvailableException;
import software.amazon.awssdk.services.appstream.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appstream.model.StartFleetRequest;
import software.amazon.awssdk.services.appstream.model.StartFleetResponse;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.StopFleetRequest;
import software.amazon.awssdk.services.appstream.model.StopFleetResponse;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.TagResourceRequest;
import software.amazon.awssdk.services.appstream.model.TagResourceResponse;
import software.amazon.awssdk.services.appstream.model.UntagResourceRequest;
import software.amazon.awssdk.services.appstream.model.UntagResourceResponse;
import software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.appstream.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.UpdateEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.UpdateFleetRequest;
import software.amazon.awssdk.services.appstream.model.UpdateFleetResponse;
import software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsResponse;
import software.amazon.awssdk.services.appstream.model.UpdateStackRequest;
import software.amazon.awssdk.services.appstream.model.UpdateStackResponse;
import software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable;
import software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable;
import software.amazon.awssdk.services.appstream.transform.AssociateApplicationFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.AssociateApplicationToEntitlementRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.AssociateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.BatchAssociateUserStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.BatchDisassociateUserStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CopyImageRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateAppBlockRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateDirectoryConfigRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateEntitlementRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateImageBuilderRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateImageBuilderStreamingUrlRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateStreamingUrlRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateUpdatedImageRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateUsageReportSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteAppBlockRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteDirectoryConfigRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteEntitlementRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteImageBuilderRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteImagePermissionsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteUsageReportSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeAppBlocksRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeApplicationFleetAssociationsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeApplicationsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeDirectoryConfigsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeFleetsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeImageBuildersRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeImagePermissionsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeSessionsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeUsageReportSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeUserStackAssociationsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DisableUserRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DisassociateApplicationFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DisassociateApplicationFromEntitlementRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.DisassociateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.EnableUserRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ExpireSessionRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ListAssociatedFleetsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ListAssociatedStacksRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ListEntitledApplicationsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.StartFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.StartImageBuilderRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.StopFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.StopImageBuilderRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateDirectoryConfigRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateEntitlementRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateImagePermissionsRequestMarshaller;
import software.amazon.awssdk.services.appstream.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.appstream.waiters.AppStreamWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link AppStreamClient}.
 *
 * @see AppStreamClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAppStreamClient implements AppStreamClient {
    private static final Logger log = Logger.loggerFor(DefaultAppStreamClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppStreamClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates the specified application with the specified fleet. This is only supported for Elastic fleets.
     * </p>
     *
     * @param associateApplicationFleetRequest
     * @return Result of the AssociateApplicationFleet operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateApplicationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateApplicationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateApplicationFleetResponse associateApplicationFleet(
            AssociateApplicationFleetRequest associateApplicationFleetRequest) throws ConcurrentModificationException,
            LimitExceededException, ResourceNotFoundException, InvalidParameterCombinationException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateApplicationFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateApplicationFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateApplicationFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateApplicationFleet");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateApplicationFleetRequest, AssociateApplicationFleetResponse>()
                            .withOperationName("AssociateApplicationFleet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateApplicationFleetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateApplicationFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an application to entitle.
     * </p>
     *
     * @param associateApplicationToEntitlementRequest
     * @return Result of the AssociateApplicationToEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateApplicationToEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateApplicationToEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateApplicationToEntitlementResponse associateApplicationToEntitlement(
            AssociateApplicationToEntitlementRequest associateApplicationToEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateApplicationToEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateApplicationToEntitlementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateApplicationToEntitlementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateApplicationToEntitlement");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateApplicationToEntitlementRequest, AssociateApplicationToEntitlementResponse>()
                            .withOperationName("AssociateApplicationToEntitlement").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateApplicationToEntitlementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateApplicationToEntitlementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified fleet with the specified stack.
     * </p>
     *
     * @param associateFleetRequest
     * @return Result of the AssociateFleet operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateFleetResponse associateFleet(AssociateFleetRequest associateFleetRequest) throws LimitExceededException,
            InvalidAccountStatusException, ResourceNotFoundException, ConcurrentModificationException,
            IncompatibleImageException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateFleet");

            return clientHandler.execute(new ClientExecutionParams<AssociateFleetRequest, AssociateFleetResponse>()
                    .withOperationName("AssociateFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(associateFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with
     * fleets that are joined to an Active Directory domain.
     * </p>
     *
     * @param batchAssociateUserStackRequest
     * @return Result of the BatchAssociateUserStack operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.BatchAssociateUserStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchAssociateUserStackResponse batchAssociateUserStack(BatchAssociateUserStackRequest batchAssociateUserStackRequest)
            throws OperationNotPermittedException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchAssociateUserStackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchAssociateUserStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchAssociateUserStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateUserStack");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateUserStackRequest, BatchAssociateUserStackResponse>()
                            .withOperationName("BatchAssociateUserStack").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(batchAssociateUserStackRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchAssociateUserStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified users from the specified stacks.
     * </p>
     *
     * @param batchDisassociateUserStackRequest
     * @return Result of the BatchDisassociateUserStack operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.BatchDisassociateUserStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchDisassociateUserStack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDisassociateUserStackResponse batchDisassociateUserStack(
            BatchDisassociateUserStackRequest batchDisassociateUserStackRequest) throws OperationNotPermittedException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDisassociateUserStackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDisassociateUserStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDisassociateUserStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDisassociateUserStack");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateUserStackRequest, BatchDisassociateUserStackResponse>()
                            .withOperationName("BatchDisassociateUserStack").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(batchDisassociateUserStackRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDisassociateUserStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the image within the same region or to a new region within the same AWS account. Note that any tags you
     * added to the image will not be copied.
     * </p>
     *
     * @param copyImageRequest
     * @return Result of the CopyImage operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyImageResponse copyImage(CopyImageRequest copyImageRequest) throws ResourceAlreadyExistsException,
            ResourceNotFoundException, ResourceNotAvailableException, LimitExceededException, InvalidAccountStatusException,
            IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CopyImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CopyImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyImage");

            return clientHandler.execute(new ClientExecutionParams<CopyImageRequest, CopyImageResponse>()
                    .withOperationName("CopyImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(copyImageRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CopyImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an app block.
     * </p>
     * <p>
     * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3
     * bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard
     * disk includes the application binaries and other files necessary to launch your applications. Multiple
     * applications can be assigned to a single app block.
     * </p>
     * <p>
     * This is only supported for Elastic fleets.
     * </p>
     *
     * @param createAppBlockRequest
     * @return Result of the CreateAppBlock operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateAppBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateAppBlock" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAppBlockResponse createAppBlock(CreateAppBlockRequest createAppBlockRequest)
            throws ConcurrentModificationException, LimitExceededException, OperationNotPermittedException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppBlockResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAppBlockResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAppBlock");

            return clientHandler.execute(new ClientExecutionParams<CreateAppBlockRequest, CreateAppBlockResponse>()
                    .withOperationName("CreateAppBlock").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAppBlockRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAppBlockRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * <p>
     * Applications are an Amazon AppStream 2.0 resource that stores the details about how to launch applications on
     * Elastic fleet streaming instances. An application consists of the launch details, icon, and display name.
     * Applications are associated with an app block that contains the application binaries and other files. The
     * applications assigned to an Elastic fleet are the applications users can launch.
     * </p>
     * <p>
     * This is only supported for Elastic fleets.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws OperationNotPermittedException, ResourceAlreadyExistsException, LimitExceededException,
            ConcurrentModificationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");

            return clientHandler.execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                    .withOperationName("CreateApplication").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required
     * to join fleets and image builders to Microsoft Active Directory domains.
     * </p>
     *
     * @param createDirectoryConfigRequest
     * @return Result of the CreateDirectoryConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDirectoryConfigResponse createDirectoryConfig(CreateDirectoryConfigRequest createDirectoryConfigRequest)
            throws ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException,
            InvalidAccountStatusException, OperationNotPermittedException, InvalidRoleException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDirectoryConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDirectoryConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDirectoryConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectoryConfig");

            return clientHandler.execute(new ClientExecutionParams<CreateDirectoryConfigRequest, CreateDirectoryConfigResponse>()
                    .withOperationName("CreateDirectoryConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDirectoryConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDirectoryConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user
     * attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and
     * streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream
     * view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
     * </p>
     *
     * @param createEntitlementRequest
     * @return Result of the CreateEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws EntitlementAlreadyExistsException
     *         The entitlement already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateEntitlementResponse createEntitlement(CreateEntitlementRequest createEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, LimitExceededException,
            EntitlementAlreadyExistsException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateEntitlementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEntitlementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEntitlement");

            return clientHandler.execute(new ClientExecutionParams<CreateEntitlementRequest, CreateEntitlementResponse>()
                    .withOperationName("CreateEntitlement").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createEntitlementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEntitlementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a fleet. A fleet consists of streaming instances that run a specified image when using Always-On or
     * On-Demand.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws ResourceAlreadyExistsException,
            ResourceNotAvailableException, ResourceNotFoundException, LimitExceededException, RequestLimitExceededException,
            InvalidAccountStatusException, InvalidRoleException, ConcurrentModificationException,
            InvalidParameterCombinationException, IncompatibleImageException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");

            return clientHandler.execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                    .withOperationName("CreateFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an image builder. An image builder is a virtual machine that is used to create an image.
     * </p>
     * <p>
     * The initial state of the builder is <code>PENDING</code>. When it is ready, the state is <code>RUNNING</code>.
     * </p>
     *
     * @param createImageBuilderRequest
     * @return Result of the CreateImageBuilder operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateImageBuilderResponse createImageBuilder(CreateImageBuilderRequest createImageBuilderRequest)
            throws LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException,
            ResourceAlreadyExistsException, ResourceNotAvailableException, ResourceNotFoundException, InvalidRoleException,
            ConcurrentModificationException, InvalidParameterCombinationException, IncompatibleImageException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageBuilderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateImageBuilderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageBuilderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageBuilder");

            return clientHandler.execute(new ClientExecutionParams<CreateImageBuilderRequest, CreateImageBuilderResponse>()
                    .withOperationName("CreateImageBuilder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createImageBuilderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageBuilderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a URL to start an image builder streaming session.
     * </p>
     *
     * @param createImageBuilderStreamingUrlRequest
     * @return Result of the CreateImageBuilderStreamingURL operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilderStreamingURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateImageBuilderStreamingUrlResponse createImageBuilderStreamingURL(
            CreateImageBuilderStreamingUrlRequest createImageBuilderStreamingUrlRequest) throws OperationNotPermittedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageBuilderStreamingUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateImageBuilderStreamingUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createImageBuilderStreamingUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageBuilderStreamingURL");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateImageBuilderStreamingUrlRequest, CreateImageBuilderStreamingUrlResponse>()
                            .withOperationName("CreateImageBuilderStreamingURL").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createImageBuilderStreamingUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateImageBuilderStreamingUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access
     * policies, and storage configurations.
     * </p>
     *
     * @param createStackRequest
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException,
            InvalidAccountStatusException, ResourceAlreadyExistsException, ConcurrentModificationException, InvalidRoleException,
            ResourceNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStack");

            return clientHandler.execute(new ClientExecutionParams<CreateStackRequest, CreateStackResponse>()
                    .withOperationName("CreateStack").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStackRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL
     * enables application streaming to be tested without user setup.
     * </p>
     *
     * @param createStreamingUrlRequest
     * @return Result of the CreateStreamingURL operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStreamingURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateStreamingUrlResponse createStreamingURL(CreateStreamingUrlRequest createStreamingUrlRequest)
            throws ResourceNotFoundException, ResourceNotAvailableException, OperationNotPermittedException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStreamingUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStreamingUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingURL");

            return clientHandler.execute(new ClientExecutionParams<CreateStreamingUrlRequest, CreateStreamingUrlResponse>()
                    .withOperationName("CreateStreamingURL").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStreamingUrlRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStreamingUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent
     * software.
     * </p>
     * <p>
     * For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html">Administer Your
     * AppStream 2.0 Images</a>, in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param createUpdatedImageRequest
     * @return Result of the CreateUpdatedImage operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUpdatedImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUpdatedImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUpdatedImageResponse createUpdatedImage(CreateUpdatedImageRequest createUpdatedImageRequest)
            throws LimitExceededException, InvalidAccountStatusException, OperationNotPermittedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ConcurrentModificationException,
            IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUpdatedImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUpdatedImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUpdatedImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUpdatedImage");

            return clientHandler.execute(new ClientExecutionParams<CreateUpdatedImageRequest, CreateUpdatedImageResponse>()
                    .withOperationName("CreateUpdatedImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUpdatedImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUpdatedImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a usage report subscription. Usage reports are generated daily.
     * </p>
     *
     * @param createUsageReportSubscriptionRequest
     * @return Result of the CreateUsageReportSubscription operation returned by the service.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUsageReportSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUsageReportSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUsageReportSubscriptionResponse createUsageReportSubscription(
            CreateUsageReportSubscriptionRequest createUsageReportSubscriptionRequest) throws InvalidRoleException,
            InvalidAccountStatusException, LimitExceededException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUsageReportSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUsageReportSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createUsageReportSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsageReportSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUsageReportSubscriptionRequest, CreateUsageReportSubscriptionResponse>()
                            .withOperationName("CreateUsageReportSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createUsageReportSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUsageReportSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new user in the user pool.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ResourceAlreadyExistsException,
            InvalidAccountStatusException, InvalidParameterCombinationException, LimitExceededException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an app block.
     * </p>
     *
     * @param deleteAppBlockRequest
     * @return Result of the DeleteAppBlock operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteAppBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteAppBlock" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAppBlockResponse deleteAppBlock(DeleteAppBlockRequest deleteAppBlockRequest)
            throws ConcurrentModificationException, ResourceInUseException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppBlockResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAppBlockResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppBlock");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppBlockRequest, DeleteAppBlockResponse>()
                    .withOperationName("DeleteAppBlock").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAppBlockRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppBlockRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws OperationNotPermittedException, ResourceInUseException, ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");

            return clientHandler.execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                    .withOperationName("DeleteApplication").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required
     * to join streaming instances to an Active Directory domain.
     * </p>
     *
     * @param deleteDirectoryConfigRequest
     * @return Result of the DeleteDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDirectoryConfigResponse deleteDirectoryConfig(DeleteDirectoryConfigRequest deleteDirectoryConfigRequest)
            throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDirectoryConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDirectoryConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDirectoryConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectoryConfig");

            return clientHandler.execute(new ClientExecutionParams<DeleteDirectoryConfigRequest, DeleteDirectoryConfigResponse>()
                    .withOperationName("DeleteDirectoryConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDirectoryConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDirectoryConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified entitlement.
     * </p>
     *
     * @param deleteEntitlementRequest
     * @return Result of the DeleteEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEntitlementResponse deleteEntitlement(DeleteEntitlementRequest deleteEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEntitlementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEntitlementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEntitlement");

            return clientHandler.execute(new ClientExecutionParams<DeleteEntitlementRequest, DeleteEntitlementResponse>()
                    .withOperationName("DeleteEntitlement").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteEntitlementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEntitlementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws ResourceInUseException,
            ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");

            return clientHandler.execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                    .withOperationName("DeleteFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot
     * provision new capacity using the image.
     * </p>
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ResourceInUseException,
            ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                    .withOperationName("DeleteImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified image builder and releases the capacity.
     * </p>
     *
     * @param deleteImageBuilderRequest
     * @return Result of the DeleteImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteImageBuilderResponse deleteImageBuilder(DeleteImageBuilderRequest deleteImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageBuilderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteImageBuilderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageBuilderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageBuilder");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageBuilderRequest, DeleteImageBuilderResponse>()
                    .withOperationName("DeleteImageBuilder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImageBuilderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageBuilderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to
     * which you previously granted these permissions can no longer use the image.
     * </p>
     *
     * @param deleteImagePermissionsRequest
     * @return Result of the DeleteImagePermissions operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteImagePermissionsResponse deleteImagePermissions(DeleteImagePermissionsRequest deleteImagePermissionsRequest)
            throws ResourceNotAvailableException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImagePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteImagePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImagePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImagePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteImagePermissionsRequest, DeleteImagePermissionsResponse>()
                            .withOperationName("DeleteImagePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteImagePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteImagePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the
     * stack is no longer available to users. Also, any reservations made for application streaming sessions for the
     * stack are released.
     * </p>
     *
     * @param deleteStackRequest
     * @return Result of the DeleteStack operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws ResourceInUseException,
            ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStack");

            return clientHandler.execute(new ClientExecutionParams<DeleteStackRequest, DeleteStackResponse>()
                    .withOperationName("DeleteStack").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStackRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables usage report generation.
     * </p>
     *
     * @param deleteUsageReportSubscriptionRequest
     * @return Result of the DeleteUsageReportSubscription operation returned by the service.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteUsageReportSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUsageReportSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUsageReportSubscriptionResponse deleteUsageReportSubscription(
            DeleteUsageReportSubscriptionRequest deleteUsageReportSubscriptionRequest) throws InvalidAccountStatusException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUsageReportSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUsageReportSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteUsageReportSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsageReportSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUsageReportSubscriptionRequest, DeleteUsageReportSubscriptionResponse>()
                            .withOperationName("DeleteUsageReportSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteUsageReportSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUsageReportSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user from the user pool.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more app blocks.
     * </p>
     *
     * @param describeAppBlocksRequest
     * @return Result of the DescribeAppBlocks operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeAppBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeAppBlocks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAppBlocksResponse describeAppBlocks(DescribeAppBlocksRequest describeAppBlocksRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppBlocksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAppBlocksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppBlocksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppBlocks");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppBlocksRequest, DescribeAppBlocksResponse>()
                    .withOperationName("DescribeAppBlocks").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAppBlocksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppBlocksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName
     * must be specified.
     * </p>
     *
     * @param describeApplicationFleetAssociationsRequest
     * @return Result of the DescribeApplicationFleetAssociations operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeApplicationFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeApplicationFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicationFleetAssociationsResponse describeApplicationFleetAssociations(
            DescribeApplicationFleetAssociationsRequest describeApplicationFleetAssociationsRequest)
            throws InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeApplicationFleetAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeApplicationFleetAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeApplicationFleetAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplicationFleetAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeApplicationFleetAssociationsRequest, DescribeApplicationFleetAssociationsResponse>()
                            .withOperationName("DescribeApplicationFleetAssociations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeApplicationFleetAssociationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeApplicationFleetAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more applications.
     * </p>
     *
     * @param describeApplicationsRequest
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicationsResponse describeApplications(DescribeApplicationsRequest describeApplicationsRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeApplicationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplications");

            return clientHandler.execute(new ClientExecutionParams<DescribeApplicationsRequest, DescribeApplicationsResponse>()
                    .withOperationName("DescribeApplications").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeApplicationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names
     * for these objects are provided. Otherwise, all Directory Config objects in the account are described. These
     * objects include the configuration information required to join fleets and image builders to Microsoft Active
     * Directory domains.
     * </p>
     * <p>
     * Although the response syntax in this topic includes the account password, this password is not returned in the
     * actual response.
     * </p>
     *
     * @param describeDirectoryConfigsRequest
     * @return Result of the DescribeDirectoryConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeDirectoryConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDirectoryConfigsResponse describeDirectoryConfigs(
            DescribeDirectoryConfigsRequest describeDirectoryConfigsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDirectoryConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDirectoryConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDirectoryConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectoryConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectoryConfigsRequest, DescribeDirectoryConfigsResponse>()
                            .withOperationName("DescribeDirectoryConfigs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDirectoryConfigsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDirectoryConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one of more entitlements.
     * </p>
     *
     * @param describeEntitlementsRequest
     * @return Result of the DescribeEntitlements operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEntitlementsResponse describeEntitlements(DescribeEntitlementsRequest describeEntitlementsRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEntitlementsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEntitlementsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEntitlementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEntitlements");

            return clientHandler.execute(new ClientExecutionParams<DescribeEntitlementsRequest, DescribeEntitlementsResponse>()
                    .withOperationName("DescribeEntitlements").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeEntitlementsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEntitlementsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all
     * fleets in the account are described.
     * </p>
     *
     * @param describeFleetsRequest
     * @return Result of the DescribeFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeFleetsResponse describeFleets(DescribeFleetsRequest describeFleetsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeFleetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleets");

            return clientHandler.execute(new ClientExecutionParams<DescribeFleetsRequest, DescribeFleetsResponse>()
                    .withOperationName("DescribeFleets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeFleetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFleetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified image builders, if the image builder names are provided.
     * Otherwise, all image builders in the account are described.
     * </p>
     *
     * @param describeImageBuildersRequest
     * @return Result of the DescribeImageBuilders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImageBuilders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeImageBuildersResponse describeImageBuilders(DescribeImageBuildersRequest describeImageBuildersRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImageBuildersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeImageBuildersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageBuildersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImageBuilders");

            return clientHandler.execute(new ClientExecutionParams<DescribeImageBuildersRequest, DescribeImageBuildersResponse>()
                    .withOperationName("DescribeImageBuilders").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeImageBuildersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeImageBuildersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     * </p>
     *
     * @param describeImagePermissionsRequest
     * @return Result of the DescribeImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeImagePermissionsResponse describeImagePermissions(
            DescribeImagePermissionsRequest describeImagePermissionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImagePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeImagePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImagePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImagePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeImagePermissionsRequest, DescribeImagePermissionsResponse>()
                            .withOperationName("DescribeImagePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeImagePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeImagePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImagePermissions(software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client.describeImagePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client
     *             .describeImagePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client.describeImagePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImagePermissions(software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImagePermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeImagePermissionsIterable describeImagePermissionsPaginator(
            DescribeImagePermissionsRequest describeImagePermissionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return new DescribeImagePermissionsIterable(this, applyPaginatorUserAgent(describeImagePermissionsRequest));
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     *
     * @param describeImagesRequest
     * @return Result of the DescribeImages operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest)
            throws InvalidParameterCombinationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeImagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImages");

            return clientHandler.execute(new ClientExecutionParams<DescribeImagesRequest, DescribeImagesResponse>()
                    .withOperationName("DescribeImages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeImagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client
     *             .describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.appstream.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation.</b>
     * </p>
     *
     * @param describeImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeImagesIterable describeImagesPaginator(DescribeImagesRequest describeImagesRequest)
            throws InvalidParameterCombinationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return new DescribeImagesIterable(this, applyPaginatorUserAgent(describeImagesRequest));
    }

    /**
     * <p>
     * Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided
     * for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not
     * provided, the default is to authenticate users using a streaming URL.
     * </p>
     *
     * @param describeSessionsRequest
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeSessionsResponse describeSessions(DescribeSessionsRequest describeSessionsRequest)
            throws InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSessionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSessionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSessions");

            return clientHandler.execute(new ClientExecutionParams<DescribeSessionsRequest, DescribeSessionsResponse>()
                    .withOperationName("DescribeSessions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeSessionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all
     * stacks in the account are described.
     * </p>
     *
     * @param describeStacksRequest
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeStacksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeStacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStacksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStacks");

            return clientHandler.execute(new ClientExecutionParams<DescribeStacksRequest, DescribeStacksResponse>()
                    .withOperationName("DescribeStacks").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeStacksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStacksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more usage report subscriptions.
     * </p>
     *
     * @param describeUsageReportSubscriptionsRequest
     * @return Result of the DescribeUsageReportSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUsageReportSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsageReportSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeUsageReportSubscriptionsResponse describeUsageReportSubscriptions(
            DescribeUsageReportSubscriptionsRequest describeUsageReportSubscriptionsRequest) throws ResourceNotFoundException,
            InvalidAccountStatusException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUsageReportSubscriptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeUsageReportSubscriptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeUsageReportSubscriptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUsageReportSubscriptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeUsageReportSubscriptionsRequest, DescribeUsageReportSubscriptionsResponse>()
                            .withOperationName("DescribeUsageReportSubscriptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeUsageReportSubscriptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeUsageReportSubscriptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The stack name
     * </p>
     * </li>
     * <li>
     * <p>
     * The user name (email address of the user associated with the stack) and the authentication type for the user
     * </p>
     * </li>
     * </ul>
     *
     * @param describeUserStackAssociationsRequest
     * @return Result of the DescribeUserStackAssociations operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUserStackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeUserStackAssociationsResponse describeUserStackAssociations(
            DescribeUserStackAssociationsRequest describeUserStackAssociationsRequest)
            throws InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUserStackAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeUserStackAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeUserStackAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserStackAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeUserStackAssociationsRequest, DescribeUserStackAssociationsResponse>()
                            .withOperationName("DescribeUserStackAssociations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeUserStackAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeUserStackAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified users in the user pool.
     * </p>
     *
     * @param describeUsersRequest
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws ResourceNotFoundException,
            InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUsers");

            return clientHandler.execute(new ClientExecutionParams<DescribeUsersRequest, DescribeUsersResponse>()
                    .withOperationName("DescribeUsers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeUsersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled.
     * This action does not delete the user.
     * </p>
     *
     * @param disableUserRequest
     * @return Result of the DisableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisableUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisableUserResponse disableUser(DisableUserRequest disableUserRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableUser");

            return clientHandler.execute(new ClientExecutionParams<DisableUserRequest, DisableUserResponse>()
                    .withOperationName("DisableUser").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(disableUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified application from the fleet.
     * </p>
     *
     * @param disassociateApplicationFleetRequest
     * @return Result of the DisassociateApplicationFleet operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateApplicationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateApplicationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateApplicationFleetResponse disassociateApplicationFleet(
            DisassociateApplicationFleetRequest disassociateApplicationFleetRequest) throws ConcurrentModificationException,
            InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateApplicationFleetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateApplicationFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateApplicationFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateApplicationFleet");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateApplicationFleetRequest, DisassociateApplicationFleetResponse>()
                            .withOperationName("DisassociateApplicationFleet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateApplicationFleetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateApplicationFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified application from the specified entitlement.
     * </p>
     *
     * @param disassociateApplicationFromEntitlementRequest
     * @return Result of the DisassociateApplicationFromEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateApplicationFromEntitlement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateApplicationFromEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateApplicationFromEntitlementResponse disassociateApplicationFromEntitlement(
            DisassociateApplicationFromEntitlementRequest disassociateApplicationFromEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateApplicationFromEntitlementResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateApplicationFromEntitlementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateApplicationFromEntitlementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateApplicationFromEntitlement");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateApplicationFromEntitlementRequest, DisassociateApplicationFromEntitlementResponse>()
                            .withOperationName("DisassociateApplicationFromEntitlement").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateApplicationFromEntitlementRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateApplicationFromEntitlementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified fleet from the specified stack.
     * </p>
     *
     * @param disassociateFleetRequest
     * @return Result of the DisassociateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DisassociateFleetResponse disassociateFleet(DisassociateFleetRequest disassociateFleetRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisassociateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFleet");

            return clientHandler.execute(new ClientExecutionParams<DisassociateFleetRequest, DisassociateFleetResponse>()
                    .withOperationName("DisassociateFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(disassociateFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications
     * from the stacks to which they are assigned.
     * </p>
     *
     * @param enableUserRequest
     * @return Result of the EnableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.EnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/EnableUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public EnableUserResponse enableUser(EnableUserRequest enableUserRequest) throws ResourceNotFoundException,
            InvalidAccountStatusException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EnableUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableUser");

            return clientHandler
                    .execute(new ClientExecutionParams<EnableUserRequest, EnableUserResponse>().withOperationName("EnableUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(enableUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new EnableUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Immediately stops the specified streaming session.
     * </p>
     *
     * @param expireSessionRequest
     * @return Result of the ExpireSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ExpireSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ExpireSessionResponse expireSession(ExpireSessionRequest expireSessionRequest) throws AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExpireSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExpireSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, expireSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExpireSession");

            return clientHandler.execute(new ClientExecutionParams<ExpireSessionRequest, ExpireSessionResponse>()
                    .withOperationName("ExpireSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(expireSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExpireSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the name of the fleet that is associated with the specified stack.
     * </p>
     *
     * @param listAssociatedFleetsRequest
     * @return Result of the ListAssociatedFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssociatedFleetsResponse listAssociatedFleets(ListAssociatedFleetsRequest listAssociatedFleetsRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociatedFleetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssociatedFleetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociatedFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociatedFleets");

            return clientHandler.execute(new ClientExecutionParams<ListAssociatedFleetsRequest, ListAssociatedFleetsResponse>()
                    .withOperationName("ListAssociatedFleets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAssociatedFleetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssociatedFleetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the name of the stack with which the specified fleet is associated.
     * </p>
     *
     * @param listAssociatedStacksRequest
     * @return Result of the ListAssociatedStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssociatedStacksResponse listAssociatedStacks(ListAssociatedStacksRequest listAssociatedStacksRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociatedStacksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssociatedStacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociatedStacksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociatedStacks");

            return clientHandler.execute(new ClientExecutionParams<ListAssociatedStacksRequest, ListAssociatedStacksResponse>()
                    .withOperationName("ListAssociatedStacks").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAssociatedStacksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssociatedStacksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of entitled applications.
     * </p>
     *
     * @param listEntitledApplicationsRequest
     * @return Result of the ListEntitledApplications operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListEntitledApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListEntitledApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEntitledApplicationsResponse listEntitledApplications(
            ListEntitledApplicationsRequest listEntitledApplicationsRequest) throws OperationNotPermittedException,
            ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEntitledApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEntitledApplicationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitledApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitledApplications");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEntitledApplicationsRequest, ListEntitledApplicationsResponse>()
                            .withOperationName("ListEntitledApplications").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listEntitledApplicationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEntitledApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders,
     * images, fleets, and stacks.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the specified fleet.
     * </p>
     *
     * @param startFleetRequest
     * @return Result of the StartFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartFleetResponse startFleet(StartFleetRequest startFleetRequest) throws ResourceNotFoundException,
            OperationNotPermittedException, LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException,
            ConcurrentModificationException, ResourceNotAvailableException, InvalidRoleException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFleet");

            return clientHandler
                    .execute(new ClientExecutionParams<StartFleetRequest, StartFleetResponse>().withOperationName("StartFleet")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startFleetRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the specified image builder.
     * </p>
     *
     * @param startImageBuilderRequest
     * @return Result of the StartImageBuilder operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartImageBuilderResponse startImageBuilder(StartImageBuilderRequest startImageBuilderRequest)
            throws ResourceNotAvailableException, ResourceNotFoundException, ConcurrentModificationException,
            InvalidAccountStatusException, IncompatibleImageException, AwsServiceException, SdkClientException,
            AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImageBuilderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartImageBuilderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImageBuilderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImageBuilder");

            return clientHandler.execute(new ClientExecutionParams<StartImageBuilderRequest, StartImageBuilderResponse>()
                    .withOperationName("StartImageBuilder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startImageBuilderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartImageBuilderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the specified fleet.
     * </p>
     *
     * @param stopFleetRequest
     * @return Result of the StopFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopFleetResponse stopFleet(StopFleetRequest stopFleetRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopFleet");

            return clientHandler.execute(new ClientExecutionParams<StopFleetRequest, StopFleetResponse>()
                    .withOperationName("StopFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopFleetRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new StopFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the specified image builder.
     * </p>
     *
     * @param stopImageBuilderRequest
     * @return Result of the StopImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopImageBuilderResponse stopImageBuilder(StopImageBuilderRequest stopImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopImageBuilderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopImageBuilderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopImageBuilderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopImageBuilder");

            return clientHandler.execute(new ClientExecutionParams<StopImageBuilderRequest, StopImageBuilderResponse>()
                    .withOperationName("StopImageBuilder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopImageBuilderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopImageBuilderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image
     * builders, images, fleets, and stacks.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this
     * operation updates its value.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>ListTagsForResource</a>. To disassociate tags from your
     * resources, use <a>UntagResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException,
            InvalidAccountStatusException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates one or more specified tags from the specified AppStream 2.0 resource.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>ListTagsForResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws OperationNotPermittedException, ConcurrentModificationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplication");

            return clientHandler.execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                    .withOperationName("UpdateApplication").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration
     * information required to join fleets and image builders to Microsoft Active Directory domains.
     * </p>
     *
     * @param updateDirectoryConfigRequest
     * @return Result of the UpdateDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDirectoryConfigResponse updateDirectoryConfig(UpdateDirectoryConfigRequest updateDirectoryConfigRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException,
            OperationNotPermittedException, InvalidRoleException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDirectoryConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDirectoryConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDirectoryConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDirectoryConfig");

            return clientHandler.execute(new ClientExecutionParams<UpdateDirectoryConfigRequest, UpdateDirectoryConfigResponse>()
                    .withOperationName("UpdateDirectoryConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDirectoryConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDirectoryConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified entitlement.
     * </p>
     *
     * @param updateEntitlementRequest
     * @return Result of the UpdateEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateEntitlementResponse updateEntitlement(UpdateEntitlementRequest updateEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateEntitlementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEntitlementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEntitlement");

            return clientHandler.execute(new ClientExecutionParams<UpdateEntitlementRequest, UpdateEntitlementResponse>()
                    .withOperationName("UpdateEntitlement").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateEntitlementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEntitlementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified fleet.
     * </p>
     * <p>
     * If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name.
     * </p>
     * <p>
     * If the fleet is in the <code>RUNNING</code> state, you can update the following based on the fleet type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Always-On and On-Demand fleet types
     * </p>
     * <p>
     * You can update the <code>DisplayName</code>, <code>ComputeCapacity</code>, <code>ImageARN</code>,
     * <code>ImageName</code>, <code>IdleDisconnectTimeoutInSeconds</code>, and <code>DisconnectTimeoutInSeconds</code>
     * attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Elastic fleet type
     * </p>
     * <p>
     * You can update the <code>DisplayName</code>, <code>IdleDisconnectTimeoutInSeconds</code>,
     * <code>DisconnectTimeoutInSeconds</code>, <code>MaxConcurrentSessions</code>, <code>SessionScriptS3Location</code>
     * and <code>UsbDeviceFilterStrings</code> attributes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the fleet is in the <code>STARTING</code> or <code>STOPPED</code> state, you can't update it.
     * </p>
     *
     * @param updateFleetRequest
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws ResourceInUseException,
            LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException, InvalidRoleException,
            ResourceNotFoundException, ResourceNotAvailableException, InvalidParameterCombinationException,
            ConcurrentModificationException, IncompatibleImageException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFleet");

            return clientHandler.execute(new ClientExecutionParams<UpdateFleetRequest, UpdateFleetResponse>()
                    .withOperationName("UpdateFleet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateFleetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates permissions for the specified private image.
     * </p>
     *
     * @param updateImagePermissionsRequest
     * @return Result of the UpdateImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateImagePermissionsResponse updateImagePermissions(UpdateImagePermissionsRequest updateImagePermissionsRequest)
            throws ResourceNotFoundException, ResourceNotAvailableException, LimitExceededException, AwsServiceException,
            SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateImagePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateImagePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateImagePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateImagePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateImagePermissionsRequest, UpdateImagePermissionsResponse>()
                            .withOperationName("UpdateImagePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateImagePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateImagePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified fields for the specified stack.
     * </p>
     *
     * @param updateStackRequest
     * @return Result of the UpdateStack operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidRoleException, InvalidParameterCombinationException, LimitExceededException,
            InvalidAccountStatusException, IncompatibleImageException, OperationNotPermittedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppStream");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStack");

            return clientHandler.execute(new ClientExecutionParams<UpdateStackRequest, UpdateStackResponse>()
                    .withOperationName("UpdateStack").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateStackRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AppStreamException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RequestLimitExceededException")
                                .exceptionBuilderSupplier(RequestLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleImageException")
                                .exceptionBuilderSupplier(IncompatibleImageException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotAvailableException")
                                .exceptionBuilderSupplier(ResourceNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAccountStatusException")
                                .exceptionBuilderSupplier(InvalidAccountStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotPermittedException")
                                .exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRoleException")
                                .exceptionBuilderSupplier(InvalidRoleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntitlementAlreadyExistsException")
                                .exceptionBuilderSupplier(EntitlementAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntitlementNotFoundException")
                                .exceptionBuilderSupplier(EntitlementNotFoundException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends AppStreamRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public AppStreamWaiter waiter() {
        return AppStreamWaiter.builder().client(this).build();
    }
}
